//
//  OffersMainViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 08.09.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OffersMainViewController: UIViewController {
  private var viewControllers: [UIViewController]!
  //  private var pagingMenuController: PagingMenuController?
  //  private let pagingMenuOptions = PagingMenuOptions()
  var specialOffers:[SpecialOffer] = []
  var pageMenu : CAPSPageMenu?
  var parameters: [CAPSPageMenuOption]?
  //  var controllerArray : [UIViewController] = []
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    localize()
  }
  
  // MARK: view life cycle
  override func viewDidLoad() {
    super.viewDidLoad()
    addBackButtonForDefault(.whiteColor())
    settingPaging()
    createViewControllers()
    
    pageMenu = CAPSPageMenu(viewControllers: viewControllers, frame: CGRectMake(0.0, 0.0, self.view.frame.width, self.view.frame.height), pageMenuOptions: parameters)
    
    // Lastly add page menu as subview of base view controller view
    // or use pageMenu controller in you view hierachy as desired
    self.view.addSubview(pageMenu!.view)
    
    pageMenu?.view.translatesAutoresizingMaskIntoConstraints = false
    let views = ["page_menu": pageMenu!.view]
    self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("H:|[page_menu]|", options: [], metrics: nil, views: views))
    self.view.addConstraints(NSLayoutConstraint.constraintsWithVisualFormat("V:|[page_menu]|", options: [], metrics: nil, views: views))
  }
  
  func settingPaging() {
    parameters = [
      .MenuItemSeparatorWidth(0),
      .UseMenuLikeSegmentedControl(true),
      .MenuItemSeparatorPercentageHeight(0),
      .ScrollMenuBackgroundColor(Color.DashboardBlueColor),
      .MenuHeight(0),
      CAPSPageMenuOption.SelectionIndicatorHeight(0)
    ]
  }
  
  func createViewControllers() {
    viewControllers = [UIViewController]()
    
//    for specialOffer in specialOffers {
//      let offersViewController = storyboard!.instantiateViewControllerWithIdentifier("OffersVC")
//        as! OffersViewController
//      offersViewController.specialOffer = specialOffer
//      viewControllers.append(offersViewController)
//    }
  }
}

extension OffersMainViewController {
  override var localizedId: String {
    return "offers"
  }
}
