//
//  BannerItemController.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 31.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit
import QuartzCore

class BannerItemController: UIViewController {
	@IBOutlet private weak var imageView : UIImageView!
	
	var banner: Banner! {
		didSet {
			ImageLoader.sharedLoader.imageForUrl(banner.image.absoluteString!, completionHandler: {
				(image, url) -> () in
				if image != nil {
					self.imageView.image = image
					self.imageView.layer.masksToBounds = true
					
					self.view.addGestureRecognizer(UITapGestureRecognizer(target: self, action: #selector(BannerItemController.openURL(_:))))
				}
			})
		}
	}
	
	func openURL(sender: AnyObject) {
		UIApplication.sharedApplication().openURL(banner.link)
	}
}
