//
//  MapPointInfoController.swift
//  kt
//
//  Created by Alexander Zalutskiy on 10.03.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit
import MapKit

class MapPointInfoController: UIViewController {
    
  var point: MKAnnotation!
    
  var mapViewController: WayProtocol!
  
  @IBOutlet private weak var addressLabel: UILabel!
  @IBOutlet private weak var nameLabel: UILabel!
  
  @IBOutlet private weak var addressTextLabel: UILabel!
  @IBOutlet private weak var nameTextLabel: UILabel!
  
  @IBOutlet private weak var cancelButton: UIButton!
  @IBOutlet private weak var wayButton: UIButton!
  
  override func viewDidLoad() {
    nameLabel.text = point.title!
    addressLabel.text = point.subtitle!
    
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    
    nameTextLabel.text = LocalizedString("map.name_of_the_object", description: "Наименование объекта").uppercaseString
    addressTextLabel.text = LocalizedString("map.address", description: "Адрес").uppercaseString
    
    cancelButton.setTitle(LocalizedString("cancel", description: "Отмена"), forState: .Normal)
    wayButton.setTitle(LocalizedString("map.get_directions", description: "Проложить маршрут"), forState: .Normal)
  }
  
  @IBAction func cancelButton_TouchUpInside(sender: UIButton?) {
    dismissViewControllerAnimated(true, completion: nil)
  }
  
    @IBAction func wayButton_TouchUpInside(sender: UIButton?) {
//        mapViewController.setWayToLocation(CLLocation(latitude: point.coordinate.latitude,
//            longitude: point.coordinate.longitude))
        let location = CLLocationCoordinate2D(latitude: point.coordinate.latitude,
            longitude: point.coordinate.longitude)

        mapViewController.getDirections(location)
        dismissViewControllerAnimated(true, completion: nil)
    }
}
