//
//  SelectBankViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SelectBankViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
  @IBOutlet var tableView: UITableView!
  let reuseCellIdentifier = "cell"
  var vc: PaymentForProviderViewController!
  
  override func viewDidLoad() {
    super.viewDidLoad()
    addBackButtonForModal(.whiteColor())
    configureBlueNavbar()
    configureTableView()
  }
  
  private func configureTableView() {
    tableView.rowHeight = UITableViewAutomaticDimension
    tableView.estimatedRowHeight = 60
  }
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    //    localize()
    tableView.reloadData()
  }
}

// UITableViewDataSource
extension SelectBankViewController {
  
  func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
    return vc!.banks.count
  }
  
  func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
    let cell = tableView.dequeueReusableCellWithIdentifier(reuseCellIdentifier, forIndexPath: indexPath) as! ServicePaymentBankCell
    cell.fillCell(vc!.banks[indexPath.row].name)
    //cell.selectionStyle = .None
    return cell
  }
}

// UITableViewDelegate
extension SelectBankViewController {
  func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
    vc.selectedBank = vc.banks[indexPath.row]
    dismissViewControllerAnimated(false, completion: {
      self.vc.tableView.reloadData()
    })
  }
}

extension SelectBankViewController {
  override var localizedId: String {
    return "select_bank"
  }
}
