//
//  OfferFormFieldCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OfferFormFieldCell : UITableViewCell, UITextFieldDelegate {
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var textField: UITextField!
  var textValue = ""
  
  override func setHighlighted(highlighted: Bool, animated: Bool) {
    super.setHighlighted(highlighted, animated: animated)
    contentView.backgroundColor = highlighted ? .clearColor() : .clearColor()
    //    backgroundColor = highlighted ? Color.BlueButtonHightlightedColor : .clearColor()
    //    accessoryView?.backgroundColor = highlighted ? Color.BlueButtonHightlightedColor : .clearColor()
  }
  
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.applyUITextFieldStyle()
    textField.textColor = Color.DarkColorForText
    titleLabel.textColor = Color.MyServicesCellGrayColor
  }
  
  func customCellSelected(vc: OfferFormViewController, title: String) {
    var perform = true
    switch title {
    case "point_type":
      break
    case "your_city":
      if vc.cities.isEmpty {
        perform = false
      }
      break
    case "region":
      if vc.regions.isEmpty {
        perform = false
      }
      break
    case "area":
      if vc.areas.isEmpty {
        perform = false
      }
      break
    case "village":
      if vc.villages.isEmpty {
        perform = false
      }
      break
    case "street":
      if vc.streets.isEmpty {
        perform = false
      }
      break
    case "house":
      if vc.houses.isEmpty {
        perform = false
      }
      break
    default: break
    }
    guard perform else { return }
    vc.performSegueWithIdentifier("showOfferModal", sender: title)
  }
  
  func fillCell(text: String, vc: OfferFormViewController) {
    textValue = text
    titleLabel.localizeWithParent(self, localizedId: text)
    titleLabel.text = titleLabel.text?.uppercaseString ?? ""
    switch text {
    case "point_type":
      textField.text = LS("offer_form.label.\(vc.pointType)") 
      break
    case "your_city":
      textField.text = vc.cities.isEmpty ? "" : vc.cityId == nil ? "" : vc.cities.filter({ (item) -> Bool in
        return item[0] == vc.cityId!
      }).first?[1]
      break
    case "region":
      textField.text = vc.regions.isEmpty ? "" : vc.regionId == nil ? "" : vc.regions.filter({ (item) -> Bool in
        return item[0] == vc.regionId!
      }).first?[1]
      break
    case "area":
      textField.text = vc.areas.isEmpty ? "" : vc.areaId == nil ? "" : vc.areas.filter({ (item) -> Bool in
        return item[0] == vc.areaId!
      }).first?[1]
      break
    case "village":
      textField.text = vc.villages.isEmpty ? "" : vc.villageId == nil ? "" : vc.villages.filter({ (item) -> Bool in
        return item[0] == vc.villageId!
      }).first?[1]
      break
    case "street":
      textField.text = vc.streets.isEmpty ? "" : vc.streetId == nil ? "" : vc.streets.filter({ (item) -> Bool in
        return item[0] == vc.streetId!
      }).first?[1]
      break
    case "house":
      textField.text = vc.houses.isEmpty ? "" : vc.houseId == nil ? "" : vc.houses.filter({ (item) -> Bool in
        return item[0] == vc.houseId!
      }).first?[1]
      break
    default: break
    }
  }
  
}

// UITextFieldDelegate
extension OfferFormFieldCell {
  
  func textFieldShouldReturn(textField: UITextField) -> Bool {
    self.endEditing(true)
    return false
  }
}

extension OfferFormFieldCell: LocalizedParent {
  var localizedId: String {
    return "offer_form"
  }
}
