//
//  OfferView.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 10.09.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OfferView: UIView {
  @IBOutlet weak var topIconView: UIImageView!
  @IBOutlet weak var textView: UITextView!
  @IBOutlet weak var pictureView: UIImageView!
  @IBOutlet weak var textViewHeight: NSLayoutConstraint!
  @IBOutlet weak var scrollView: UIScrollView!
  @IBOutlet var contentView: UIView!
  weak var activeField: UITextField?
  @IBOutlet var helpButtonBottomSpace: NSLayoutConstraint!
  
  class func instanceFromNib() -> OfferView {
    return UINib(nibName: "OfferView", bundle: NSBundle.mainBundle()).instantiateWithOwner(self, options: nil)[0] as! OfferView
  }
  
  override func awakeFromNib() {
    super.awakeFromNib()
  }
  
  func resizeScrollViewToFitSubviews() {
    contentView.resizeToFitSubviews()
    scrollView.contentSize = CGSize(width: scrollView.frame.size.width, height: contentView.frame.height)
  }

}
