//
//  CallbackSelectCell.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 02.02.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class CallbackSelectCell: UITableViewCell {
	@IBOutlet private weak var titleLabel: UILabel!
	@IBOutlet weak var valueLabel: UILabel!
	@IBOutlet private weak var button: UIButton!
	
	func setTitle(title: String, placeholder: String, info: CallbackPlaceProtocol?) {
		titleLabel.text = title
		
		if info == nil {
			valueLabel.text = placeholder
			valueLabel.textColor = UIColor(red: 0.78, green: 0.8, blue: 0.8, alpha: 1.0)
		} else {
			valueLabel.text = info!.text
			valueLabel.textColor = Color.DarkColorForText
		}
		
//		button.tag = row
	}
}
