//
//  DetalizationCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 13.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class DetalizationCell: UITableViewCell {
  @IBOutlet weak var leftDateAndTimeLabel: UILabel!
  @IBOutlet weak var rightDateAndTimeLabel: UILabel!
  @IBOutlet weak var leftPackInLabel: UILabel!
  @IBOutlet weak var rightPackInLabel: UILabel!
  @IBOutlet weak var leftPackOutLabel: UILabel!
  @IBOutlet weak var rightPackOutLabel: UILabel!
  @IBOutlet weak var leftPriceLabel: UILabel!
  @IBOutlet weak var RightPriceLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    removeLeftMargin()
    configureViews()
  }
  
  func configureViews() {
    leftDateAndTimeLabel.textColor = Color.DarkColorForText
    leftPackInLabel.textColor = Color.DarkColorForText
    leftPackOutLabel.textColor = Color.DarkColorForText
    leftPriceLabel.textColor = Color.DarkColorForText
    
    rightDateAndTimeLabel.textColor = Color.DarkColorForText
    rightPackInLabel.textColor = Color.DarkColorForText
    rightPackOutLabel.textColor = Color.DarkColorForText
    RightPriceLabel.textColor = Color.DarkColorForText
  }
  
  func fillCell(detalization: AltelDetalization) {
    leftDateAndTimeLabel.localizeWithParent(self, localizedId: "date_time")
    leftPackInLabel.localizeWithParent(self, localizedId: "packet_in")
    leftPackOutLabel.localizeWithParent(self, localizedId: "packet_out")
    leftPriceLabel.localizeWithParent(self, localizedId: "price")
    
    rightDateAndTimeLabel.setTextAndSizeToFit(detalization.startTime)
    rightPackInLabel.setTextAndSizeToFit("\(detalization.packetIn)")
    rightPackOutLabel.setTextAndSizeToFit("\(detalization.packetOut)")
    RightPriceLabel.setTextAndSizeToFit("\(detalization.price)")
  }
  
}

extension DetalizationCell: LocalizedParent {
  var localizedId: String {
    return "altel_detalization"
  }
}
