//
//  UIListBoxItemTableViewCell.swift
//  kt
//
//  Created by Admin on 17.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class ListBoxItemCellData : CellData {
    override internal var cellType: CellType { return CellType.ListBoxItemCell}

    internal var listBoxItem : ListBoxItemProtocol?
    
    init(listBoxItem: ListBoxItemProtocol) {
        super.init()
        self.listBoxItem = listBoxItem
    }
}

class UIListBoxItemTableViewCell : UIBaseTableViewCell {
    @IBOutlet weak var titleLabel: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
        titleLabel.textColor = Color.TitleBlackColor
    }
    
    override func fillWithCellData(cellData: CellData) {
        super.fillWithCellData(cellData)
        let myCellData = cellData as! ListBoxItemCellData
        titleLabel.setTextAndSizeToFit(myCellData.listBoxItem!.listItemTitle)
    }

}
