//
//  WhiteTriangleView.swift
//  kt
//
//  Created by neox on 17.07.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class WhiteTriangleView: UIView {

    override func awakeFromNib() {
        super.awakeFromNib()
    }
    
    override func drawRect(rect: CGRect) {
        
        // Get Height and Width
        let layerHeight = layer.frame.height
        let layerWidth = layer.frame.width
        
        // Create Path
        let bezierPath = UIBezierPath()
        
        // Draw Points
        bezierPath.moveToPoint(CGPoint(x: 0, y: 0))
        bezierPath.addLineToPoint(CGPoint(x: layerWidth, y: 0))
        bezierPath.addLineToPoint(CGPoint(x: layerWidth, y: layerHeight))
        bezierPath.addLineToPoint(CGPoint(x: 0, y: 0))
        bezierPath.closePath()
        
        // Apply Color
        UIColor.whiteColor().setFill()
        bezierPath.fill()
        
        // Mask to Path
        let shapeLayer = CAShapeLayer()
        shapeLayer.path = bezierPath.CGPath
        layer.mask = shapeLayer
    }

}
