//
//  ButtonView.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.01.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ButtonView : UIView {
  @IBOutlet weak var titleLabel: UILabel!
  @IBOutlet weak var icon: UIImageView!
  var titleColor: UIColor!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    titleColor = titleLabel.textColor
    fillLabel()
    titleLabel.translatesAutoresizingMaskIntoConstraints = false
    icon.translatesAutoresizingMaskIntoConstraints = false
    translatesAutoresizingMaskIntoConstraints = false
    sizeToFit()
  }
  
  func fillLabel() {
    switch tag {
    case 1:
      titleLabel.text = LS("cabinet.label.my_services")
      break
    case 2:
      titleLabel.text = LS("cabinet.label.offers")
      break
    case 3:
      titleLabel.text = LS("cabinet.label.caches_and_payments")
      break
    case 4:
      titleLabel.text = LS("cabinet.label.settings")
      break
    case 5:
      titleLabel.text = LS("cabinet.label.software_rent")
      break
    case 6:
      titleLabel.text = LS("cabinet.label.notifications")
      break
    default:
      break
    }
    titleLabel.sizeToFit()
  }
  
  func highlightCell(tapped: Bool) {
    titleLabel.textColor = tapped ? Color.AuthBlueHighlightedColor : titleColor
    switch tag {
    case 1:
      icon.image = UIImage(named: tapped ? "cabinet_myservices_tap" : "cabinet_myservices_normal")
      break
    case 2:
      icon.image = UIImage(named: tapped ? "cabinet_proposition_tap" : "cabinet_proposition_normal")
      break
    case 3:
      icon.image = UIImage(named: tapped ? "cabinet_payments_tap" : "cabinet_payments_normal")
      break
    case 4:
      icon.image = UIImage(named: tapped ? "cabinet_settings_tap" : "cabinet_settings_normal")
      break
    case 5:
      icon.image = UIImage(named: tapped ? "cabinet_soft_tap" : "cabinet_soft_normal")
      break
    case 6:
      icon.image = UIImage(named: tapped ? "cabinet_notifications_tap" : "cabinet_notifications_normal")
      break
    default:
      break
    }
  }
  
  //  override func touchesMoved(touches: Set<UITouch>, withEvent event: UIEvent?) {
  //    super.touchesMoved(touches, withEvent: event)
  //    //    var location: CGPoint?
  //
  //    let touch: UITouch = touches[touches.startIndex.advancedBy(touches.count - 1)]
  //
  //    //    if #available(iOS 9.1, *) {
  //    //      print("touch.azimuthUnitVectorInView(self) \(touch.(self))")
  //    //    } else {
  //    // Fallback on earlier versions
  //    //    }
  //    //    print(touche.phase)
  //    if touch.phase == UITouchPhase.Stationary {
  //      print("Stationary")
  //    } else
  //      if touch.phase == UITouchPhase.Moved {
  //        print("Moved")
  //      } else
  //        if touch.phase == UITouchPhase.Cancelled {
  //          print("Cancelled")
  //        } else
  //          if touch.phase == UITouchPhase.Ended {
  //            print("ended")
  //    }
  //  }
  //
  //  override func touchesCancelled(touches: Set<UITouch>?, withEvent event: UIEvent?) {
  //    super.touchesCancelled(touches, withEvent: event)
  //    highlightCell(false)
  //    print("touchesCancelled")
  //  }
  //
  //  override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
  //    super.touchesEnded(touches, withEvent: event)
  //    highlightCell(false)
  //    print("touchesEnded")
  //  }
  //
  //  override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
  //    super.touchesBegan(touches, withEvent: event)
  //    highlightCell(true)
  //  }
}
