//
//  GreenButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 31.01.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class GreenButton: UIButton {
  
  override func awakeFromNib() {
    super.awakeFromNib()
    self.layer.cornerRadius = 7
    setTitleColor(.whiteColor(), forState: UIControlState.Normal)
    setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
    setTitleColor(.whiteColor(), forState: UIControlState.Selected)
    setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
    setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
  }
  
  override var highlighted: Bool {
    didSet {
      backgroundColor = highlighted ? Color.WhiteGreenColor : Color.DarkGreenColor
    }
  }
}
