//
//  ModalButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class ModalButton: UIButton {
  
  override func awakeFromNib() {
    super.awakeFromNib()
    roundCorners([tag == 0 ? UIRectCorner.BottomLeft : UIRectCorner.BottomRight], radius: 7)
    setTitleColor(Color.AuthBlueNormalColor, forState: UIControlState.Normal)
    setTitleColor(Color.AuthBlueNormalColor, forState: UIControlState.Highlighted)
  }
  
  override var highlighted: Bool {
    didSet {
      backgroundColor = highlighted ? Color.ButtonClickedDefaultColor : UIColor.clearColor()
    }
  }
  
}
