//
//  NextButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class NextButton: UIButton {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setTitleColor(.whiteColor(), forState: UIControlState.Normal)
        setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
        setTitleColor(.whiteColor(), forState: UIControlState.Selected)
        setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
        setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
        backgroundColor = Color.AuthBlueNormalColor
        layer.cornerRadius = 7
    }
    
    override var highlighted: Bool {
        didSet {
            backgroundColor = highlighted ? Color.AuthBlueHighlightedColor : Color.AuthBlueNormalColor
        }
    }
}
