//
//  VerticalButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 24.08.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class VerticalButton: UIButton {
  var titleColor: UIColor!
  @IBOutlet weak var pictureView: UIImageView!
  @IBOutlet weak var label: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    titleColor = label.textColor
    fillLabel()
    label.translatesAutoresizingMaskIntoConstraints = false
    pictureView.translatesAutoresizingMaskIntoConstraints = false
    translatesAutoresizingMaskIntoConstraints = false
    sizeToFit()
  }
  
  func fillLabel() {
    switch tag {
    case 1:
      label.text = LS("cabinet.label.my_services")
      break
    case 2:
      label.text = LS("cabinet.label.offers")
      break
    case 3:
      label.text = LS("cabinet.label.caches_and_payments")
      break
    case 4:
      label.text = LS("cabinet.label.settings")
      break
    case 5:
      label.text = LS("cabinet.label.software_rent")
      break
    case 6:
      label.text = LS("cabinet.label.claims")
      break
    default:
      break
    }
    label.sizeToFit()
  }
  
  func highlightCell(tapped: Bool) {
    label.textColor = tapped ? Color.AuthBlueHighlightedColor : titleColor
    switch tag {
    case 1:
      pictureView.image = UIImage(named: tapped ? "cabinet_myservices_tap" : "cabinet_myservices_normal")
      break
    case 2:
      pictureView.image = UIImage(named: tapped ? "cabinet_proposition_tap" : "cabinet_proposition_normal")
      break
    case 3:
      pictureView.image = UIImage(named: tapped ? "cabinet_payments_tap" : "cabinet_payments_normal")
      break
    case 4:
      pictureView.image = UIImage(named: tapped ? "cabinet_settings_tap" : "cabinet_settings_normal")
      break
    case 5:
      pictureView.image = UIImage(named: tapped ? "cabinet_soft_tap" : "cabinet_soft_normal")
      break
    case 6:
      pictureView.image = UIImage(named: tapped ? "cabinet_notifications_tap" : "cabinet_notifications_normal")
      break
    default:
      break
    }
  }
  
  override var highlighted: Bool {
    didSet {
      highlightCell(highlighted)
    }
  }
  
}
