//
//  ActiveSession.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ActiveSession {
  var startTime: NSDate?
  var framedIpAddress: String?
  var inputOctets: Int?
  var outputOctets: Int?
  var serviceInfo: String?
  
  init(json: JSON) {
    if let startTime = json["start_time"].string {
      let dateFormatter = NSDateFormatter()
      dateFormatter.locale = NSLocale(localeIdentifier: "en_US_POSIX")
      dateFormatter.dateFormat = "dd-MM-yy"
      self.startTime = dateFormatter.dateFromString(startTime)
        if self.startTime == nil {
            dateFormatter.dateFormat = "yy-MM-dd HH:mm:ss"
            self.startTime = dateFormatter.dateFromString(startTime)
        }
    }
    self.framedIpAddress = json["framed_ip_address"].string
    self.inputOctets = json["input_octets"].int
    self.outputOctets = json["output_octets"].int
    self.serviceInfo = json["service_info"].string
  }
  
  func dateAndMonthFormat() -> String? {
    guard let systemDate = startTime else {
      return nil
    }
    let components = systemDate.getComponents()
    let year =  components.year
    let month = components.month
    let dateFormatter = NSDateFormatter()
    dateFormatter.locale = AppLocalization.language().locale
    if #available(iOS 9.0, *) {
      return "\(dateFormatter.standaloneMonthSymbols[month - 1].localizedCapitalizedString) \(year)"
    } else {
      // Fallback on earlier versions
      return "\(dateFormatter.standaloneMonthSymbols[month - 1].capitalizedStringWithLocale(NSLocale.currentLocale())) \(year)"
    }
  }
  
}
