//
//  ServiceItem.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 28.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class ServiceItem {
    
    var id : Int?
    var name : String?
    var key: String?
    var price: Int?
    var type: String?
    var html: String!
    var image: NSURL!
    var logo: NSURL!
    var link: NSURL!
    var title: String?
    var data: [[String: AnyObject]]?
    var rates: [Rate] = []
    var service : Service?
    var isShowConnectButton : Bool?
    
    var tariffs: [Tariff]!
    
    class Rate {
        var name: String = ""
        var price: String = ""
        var desc: String = ""
        
        init(name: String, price: String, desc: String) {
            self.name = name
            self.price = price
            self.desc = desc
        }
    }
    
    init() {
        
    }
    
    //  "service_id":1,
    //  "title": "Kaspersky Internet Security для всех       устройств (2 устройства)",
    //  "price": 850,
    //  "verbose_description_full": "<p>Оптимальная защита, для активных интернет пользователей.</p>\n<p><strong>Можно установить на 2 устройства.</strong>

    
    init(id: Int? = nil, name: String, key: String? = nil, type: String? = nil, data: [[String: AnyObject]]? = nil) {
        self.id = id
        self.name = name
        self.type = type
        self.data = data
        self.key = key
    }
    
    init(json: JSON) {
        id = json["service_id"].intValue
        name = json["title"].stringValue
        //    key = json["key"].string
    }
    

    
    init(fullJson: JSON) {
        
        //    "rates": [{
        //    "name": "",
        //    "price": "5 999"
        //    }, {
        //    "name": "",
        //    "price": "6 999"
        //    }, {
        //    "name": "",
        //    "price": "7 999"
        //    }, {
        //    "name": "",
        //    "price": "9 999"
        //    }]
        
        id = fullJson["id"].intValue
        name = fullJson["name"].stringValue
        link = NSURL(string: fullJson["link"].stringValue)
        html = fullJson["desc"].stringValue
        image = NSURL(string: fullJson["background"].stringValue)
        logo = NSURL(string: fullJson["logo"].stringValue)
        title = fullJson["slogan"].stringValue
        
        if let jsonRates = fullJson["rates"].array where !jsonRates.isEmpty {
            rates = []
            for jsonRate in jsonRates {
                rates.append(Rate(name: jsonRate["name"].stringValue, price: jsonRate["price"].stringValue, desc: jsonRate["desc"].stringValue))
            }
        }
        
        
        
        tariffs = [Tariff]()
        for (_, subJson) in fullJson["service.tariffs"] {
            tariffs.append(Tariff(json: subJson))
        }
        
        isShowConnectButton = fullJson["show_connect_button"].boolValue
    }
}
