//
//  FullDamageModalViewController.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class FullDamageModalViewController: UIViewController, UITableViewDataSource {
    var vc: ClaimListViewController!
    var fullDamage: FullDamage?
    var claim: Claim?
    var tabIndex = -1
    var cells: [String] = ["id",
                           "device_id",
                           "created",
                           "claim_type",
                           "claimer",
                           "status"]
    var scCells: [String] = ["id",
                             "device_id",
                             "created",
                             "pretension_type",
                             "comment",
                             "status"]
    var selectedCells: [String] = []
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = LS("full_damage_modal.navigation_title")
        configureBlueNavbar()
        addBackButtonForDefault(.whiteColor())
        
        var isNeedShowingRightButton = true
        if (fullDamage != nil) {
            isNeedShowingRightButton = !(fullDamage?.isCanceled())!
        } else
        if (claim != nil) {
            isNeedShowingRightButton = !(claim?.isCanceled())!
        }
        
        if (isNeedShowingRightButton) {
            let barButtonItem = UIBarButtonItem(title: LS("full_damage_modal.button.delete"), style: .Plain, target: self, action: #selector(deleteClick))
            barButtonItem.setTitleTextAttributes([NSFontAttributeName : UIFont.systemFontOfSize(17), NSForegroundColorAttributeName: UIColor.whiteColor()], forState: .Normal)
            self.navigationItem.rightBarButtonItem = barButtonItem
        }
        
        if tabIndex == 0 {
            selectedCells = cells
        } else {
            selectedCells = scCells
        }
    }
    
    func deleteClick() {
        if (tabIndex == 0) {
            vc.deleteFullDamage(fullDamage!, sender: self)
        } else {
            vc.deleteClaim(claim!, sender: self)
        }
    }
    
}

// UITableViewDataSource
extension FullDamageModalViewController {
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return selectedCells.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("cell", forIndexPath: indexPath) as! FullDamageModalTableCell
        cell.fillCell(selectedCells[indexPath.row], fullDamage: fullDamage, claim: claim, tabIndex: tabIndex)
        //cell.selectionStyle = .None
        return cell
    }
}
