//
//  UICreateFastPayViewController.swift
//  kt
//
//  Created by Admin on 19.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class UICreateFastPayViewController : UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    //MARK: - IBOutlest
    
    @IBOutlet weak var tableView : UITableView!
    @IBOutlet weak var lblDescription : UILabel!
    @IBOutlet weak var btnDelete : UIButton!
    @IBOutlet weak var btnCreate : UIButton!
    
    var cellsData : [TextBoxCellData] = []
    var cells : [UIBaseTableViewCell] = []
    var cellDataName : TextBoxCellData?
    var cellDataPhoneNumber : TextBoxCellData?
    var fastPayForEditing : FastPayItem?
    
    //MARK: - System functions
    
    override func viewDidLoad() {
        super.viewDidLoad()
        createCells()
        tableView.reloadData()
        self.title = isEditableMode() ? LS("fastPay_create_editingTitle") : LS("fastPay_create_createTitle")
        if (!isEditableMode()) {
            btnDelete.hidden = true
            btnCreate.setTitle(LS("fastPay_create_button_createTitle"), forState: UIControlState.Normal)
        } else {
            btnCreate.setTitle(LS("fastPay_create_button_saveChangesTitle"), forState: UIControlState.Normal)
            btnDelete.setTitle(LS("fastPay_create_button_deleteTitle"), forState: UIControlState.Normal)
        }
    }
    
    //MARK: - Functions
    
    func createCells() {
        cells = []
        createCellsData()
        for var cellData in cellsData {
            let cell = tableView.dequeueReusableCellWithIdentifier(cellData.cellType.reuseIdentifier) as! UIBaseTableViewCell
            cell.fillWithCellData(cellData)
            cell.selectionStyle = .None
            cells.append(cell)
            if (cellData.cellType != .TitleValueCell) {
                cell.selectionStyle = .None
            }
        }
    }
    
    func createCellsData() {
        cellsData = []
        let valueName = fastPayForEditing != nil ? fastPayForEditing!.title : ""
        cellDataName = TextBoxCellData(title: LS("fastPay_create_cardName").uppercaseString, value: valueName, placeholder: LS("fastPay_create_cellName_placeholder")) { (object) -> Bool in
            var result = false
            if (object != nil) {
                let st = object as! String
                if (st.characters.count > 0) {
                    result = true;
                }
            }
            return result
        }
        
        let valuePhone = fastPayForEditing != nil ? fastPayForEditing?.phoneNumber : ""
        cellDataPhoneNumber = TextBoxCellData(title: LS("fastPay_create_phoneNumber").uppercaseString, value: valuePhone!, placeholder: LS("fastPay_create_cellPhone_placeholder")) { (object) -> Bool in
            var result = false
            if (object != nil) {
                let st = object as! String
                if isValidPhoneNumber(st) {
                    result = true;
                }
            }
            return result
        }
        cellDataPhoneNumber?.keyboardType = .PhonePad
        
        cellsData.append(cellDataName!)
        cellsData.append(cellDataPhoneNumber!)
    }
    
    func showAlert(title : String, message: String) {
        let ac = UIAlertController(title: title, message: message, preferredStyle: UIAlertControllerStyle.Alert)
        let okAction = UIAlertAction(title: LS("ok"), style: .Default, handler: nil)
        ac.addAction(okAction)
        self.presentViewController(ac, animated: true, completion: nil)
    }
    
    func checkForm() -> Bool {
     
        for var cell in cells {
            cell.updateCellData()
        }
        
        var result = true
        
        var message : String = ""
        if (!(cellDataName!.checkValues())) {
            message.appendContentsOf("\(LS("fastPay_create_validationFail_cellName")) \n")
        }
        
        if (!(cellDataPhoneNumber!.checkValues())) {
            message.appendContentsOf("\(LS("fastPay_create_validationFail_cellPhone")) \n")
        }

        if message.characters.count > 0 {
            result = false
            showAlert(LS("fastPay_create_alertTitle_error"), message: message)
        }
        
        return result
    }
    
    
    func sendRequestBalance(onSuccess:() -> Void, onFailure : () -> Void) {
        Facade.sharedInstance().getBalance((cellDataPhoneNumber?.value)!, onSuccess: { (balance) in
            onSuccess()
        }) { (nsError) in
            onFailure()
        }

    }
    
    func isEditableMode() -> Bool {
        return fastPayForEditing != nil
    }
    
    //MARK: - IBActions
    
    @IBAction func btnCreateFastPay_action(sender: AnyObject) {
        if (checkForm()) {
            sendRequestBalance({
                let name = self.cellDataName?.value
                let phoneNumber = self.cellDataPhoneNumber?.value
                if (self.fastPayForEditing != nil) {
                    FastPayManager.sharedInstance().removeFromStoreFastPay(self.fastPayForEditing!)
                }
                let fastPayItem = FastPayItem(title: name!, phoneNumber: phoneNumber!)
                FastPayManager.sharedInstance().addInStoreFastPay(fastPayItem)
                
                self.back()
                }, onFailure: {
                    self.showAlert(LS("fastPay_create_alertTitle_error"), message: LS("fastPay_create_validationFail_cellPhone"))
            })        }
    }

    @IBAction func btnDeleteFastPay_action(sender: AnyObject) {
        FastPayManager.sharedInstance().removeFromStoreFastPay(self.fastPayForEditing!)
        self.back()
    }
}

//MARK: UITableViewDataSource
extension UICreateFastPayViewController {
    
    func tableView(tableView: UITableView, heightForRowAtIndexPath indexPath: NSIndexPath) -> CGFloat {
        return 70
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = cells[indexPath.row]
        cell.hideSeparatorLine()
        return cell
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        return cellsData.count
    }
}

//MARK: UITableViewDelegate
extension UICreateFastPayViewController {
    
    func tableView(tableView: UITableView, didSelectRowAtIndexPath indexPath: NSIndexPath) {
        
    }
    
}
