//
//  OnlinePaymentTitleCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OnlinePaymentTitleCell : UITableViewCell {
  @IBOutlet weak var firstLabel: UILabel!
  @IBOutlet weak var secondLabel: UILabel!
  @IBOutlet weak var thirdLabel: UILabel!
  @IBOutlet weak var fourthLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    localizeSubviews()
    contentView.backgroundColor = Color.DashboardBlueColor
  }
  
  private func localizeSubviews() {
    firstLabel.localizeWithParent(self, localizedId: "please_fill_and_confirm_the_payment_data")
    secondLabel.localizeWithParent(self, localizedId: "no_commission_payment_is_available_now")
    thirdLabel.localizeWithParent(self, localizedId: "supported_banking_systems")
    fourthLabel.localizeWithParent(self, localizedId: "supported_auths")
  }
  
}

extension OnlinePaymentTitleCell: LocalizedParent {
  var localizedId: String {
    return "online_payment"
  }
}
