//
//  ServiceCell.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class ServiceCell: UITableViewCell {
  @IBOutlet private weak var iconView: UIImageView!
  @IBOutlet private weak var nameLabel: UILabel!

  func setService(servicesItem : ServiceItem, withRow row: Int) {
    
    contentView.backgroundColor = servicesItem.service!.colorForRow(row)
    //contentView.backgroundColor = UIColor(red: 1.0, green: 0.44, blue: 0.18, alpha: 1.0)
    iconView.image = UIImage(named: servicesItem.service!.imageName)
    nameLabel.setTextAndSizeToFit(servicesItem.name)
    
    selectedBackgroundView = UIView(frame: contentView.frame)
    selectedBackgroundView!.backgroundColor = servicesItem.service!.colorForRow(row)
    //selectedBackgroundView!.backgroundColor = UIColor(red: 0.0, green: 0.44, blue: 0.18, alpha: 1.0)
    //selectedBackgroundView!.alpha = 0.8
  }
  
  override func setSelected(selected: Bool, animated: Bool) {
    
    let block : () -> Void = {
      if selected {
        self.contentView.alpha = 0.8
      } else {
        self.contentView.alpha = 1.0
      }
    }
    
    if animated {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
  
  override func setHighlighted(highlighted: Bool, animated: Bool) {
    let block : () -> Void = {
      if highlighted {
        self.contentView.alpha = 0.8
      } else {
        self.contentView.alpha = 1.0
      }
    }
    
    if animated {
      UIView.animateWithDuration(0.2, animations: block)
    } else {
      block()
    }
  }
}
