//
//  UITextBoxWithInfoTableViewCell.swift
//  kt
//
//  Created by Admin on 21.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class TextBoxInfoCellData : TextBoxCellData {
    internal var onClickInfo : () -> Void = {}
    
    internal init(title:String, value:String, placeholder:String, onValidate:(AnyObject?) -> Bool, onClickInfo:() -> Void) {
        super.init(title: title, value: value, placeholder: placeholder, onValidate: onValidate)
        self.onClickInfo = onClickInfo
    }
    
    override internal var cellType: CellType { return CellType.TextBoxCellWithInfo}
}

class UITextBoxWithInfoTableViewCell : UITextBoxTableViewCell {
    
    private var myCellData : TextBoxInfoCellData!
    
    override func fillWithCellData(cellData: CellData) {
        super.fillWithCellData(cellData)
        self.myCellData = cellData as! TextBoxInfoCellData
    }
    
    @IBAction func btn_infoAction(sender: AnyObject) {
        let cellData = self.cellData as! TextBoxInfoCellData
        cellData.onClickInfo()
    }

    
}
