//
//  CabinetButton.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 09.02.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class CabinetButton : UIButton {
  var titleColor: UIColor!
  override func awakeFromNib() {
    super.awakeFromNib()
//    centerImageAndTitle()
    self.sizeToFit()
    self.layoutIfNeeded()
    titleColor = titleLabel!.textColor
    switch tag {
    case 1:
      titleLabel?.text = LocalizedString("cabinet.label.my_services")
      break
    case 2:
      titleLabel?.text = LocalizedString("cabinet.label.offers")
      break
    case 3:
      titleLabel?.text = LocalizedString("cabinet.label.caches_and_payments")
      break
    case 4:
      titleLabel?.text = LocalizedString("cabinet.label.settings")
      break
    case 5:
      titleLabel?.text = LocalizedString("cabinet.label.history")
      break
    case 6:
      titleLabel?.text = LocalizedString("cabinet.label.notifications")
      break
    default:
      break
    }
  }
  
  override func touchesEnded(touches: Set<UITouch>, withEvent event: UIEvent?) {
    titleLabel?.textColor = titleColor
    switch tag {
    case 1:
      imageView?.image = UIImage(named: "cabinet_myservices_normal")
      break
    case 2:
      imageView?.image = UIImage(named: "cabinet_proposition_normal")
      break
    case 3:
      imageView?.image = UIImage(named: "cabinet_payments_normal")
      break
    case 4:
      imageView?.image = UIImage(named: "cabinet_settings_normal")
      break
    case 5:
      imageView?.image = UIImage(named: "cabinet_history_normal")
      break
    case 6:
      imageView?.image = UIImage(named: "cabinet_notifications_normal")
      break
    default:
      break
    }
  }
  
  override func touchesBegan(touches: Set<UITouch>, withEvent event: UIEvent?) {
    titleLabel?.textColor = UIColor(red: 103/255, green: 183/255, blue: 245/255, alpha: 1)
    switch tag {
    case 1:
      imageView?.image = UIImage(named: "cabinet_myservices_tap")
      break
    case 2:
      imageView?.image = UIImage(named: "cabinet_proposition_tap")
      break
    case 3:
      imageView?.image = UIImage(named: "cabinet_payments_tap")
      break
    case 4:
      imageView?.image = UIImage(named: "cabinet_settings_tap")
      break
    case 5:
      imageView?.image = UIImage(named: "cabinet_history_tap")
      break
    case 6:
      imageView?.image = UIImage(named: "cabinet_notifications_tap")
      break
    default:
      break
    }
  }
  
  func centerImageAndTitle() {
    let DEFAULT_SPACING:CGFloat = 6.0
    self.centerImageAndTitle(DEFAULT_SPACING)
  }
  
  func centerImageAndTitle(spacing: CGFloat) {
    let imageSize = self.imageView!.frame.size
    let titleSize = (NSString(string: self.titleLabel!.text!)).sizeWithAttributes([NSFontAttributeName: self.titleLabel!.font])
//    let titleSize = self.titleLabel!.frame.size
    // get the height they will take up as a unit
    let totalHeight = (imageSize.height + titleSize.height + spacing)
    
    // raise the image and push it right to center it
    self.imageEdgeInsets = UIEdgeInsetsMake(-(totalHeight - imageSize.height), 0.0, 0.0, -titleSize.width)
    
    // lower the text and push it left to center it
    self.titleEdgeInsets = UIEdgeInsetsMake(0.0, -imageSize.width, -(totalHeight - titleSize.height),0.0);
  }
}
