//
//  GetSpecialOffersRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 02.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
//  //{
//  "house":165745,
//  "type":"village",
//  "service_type":1,
//  "portal_city_id": 5
//}
//  {
//    "house":38593,
//    "type":"city",
//    "service_type":1,
//    "portal_city_id": 5
//}
class GetSpecialOffersRequest {
  var portal_city_id: String?
  var service_type: String?
  var type: String?
  var house: String?
  
  init(portal_city_id: String? = nil, service_type: String? = nil, type: String? = nil, house: String? = nil) {
    self.portal_city_id = portal_city_id
    self.service_type = service_type
    self.type = type
    self.house = house
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if portal_city_id.isNilOrEmpty || service_type.isNilOrEmpty || type.isNilOrEmpty || house.isNilOrEmpty {
      isValid = false
    }
    return isValid
  }

  var params: [String: AnyObject] {
    let params = ["portal_city_id": portal_city_id!,
                  "service_type": service_type!,
                  "type": type!,
                  "house": house!]
    return params
  }
  
}
