//
//  OfferCallbackRequest.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 01.06.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class OfferCallbackRequest {
  var region: String?
  var regionType: String?
  var name: String?
  var phone: String?
  var email: String?
  var formType: String?
  var type: Int?
  var serviceId: Int?
  var validationMessage = ""
  
  init(type: Int? = nil, serviceId: Int? = nil, region: String? = nil, regionType: String? = nil, name: String? = nil, email: String?, phone: String? = nil, formType: String? = nil) {
    self.region = region
    self.regionType = regionType
    self.name = name
    self.email = email
    self.phone = phone
    self.formType = formType
    self.type = type
    self.serviceId = serviceId
  }
  
  func validateFields() -> Bool {
    var isValid = true
    let badCharacters = NSCharacterSet.decimalDigitCharacterSet().invertedSet
    if region.isNilOrEmpty || regionType.isNilOrEmpty || name.isNilOrEmpty || phone.isNilOrEmpty || formType.isNilOrEmpty {
      isValid = false
      validationMessage = LS("error_fill_all_fields")
    } else {
      if phone?.characters.count < 10 || phone?.characters.count > 10 || phone?.rangeOfCharacterFromSet(badCharacters) != nil {
        validationMessage = validationMessage == "" ? LS("offer_callback.label.incorrect_phone_number") : "\(validationMessage); \(LS("offer_callback.label.incorrect_phone_number"))"
        isValid = false
      }
      if let email = email where !isValidEmail(email) {
        validationMessage = validationMessage == "" ? LS("offer_callback.label.incorrect_email") : "\(validationMessage); \(LS("offer_callback.label.incorrect_email"))"
        isValid = false
      }
    }
    //    if phone?.rangeOfCharacterFromSet(badCharacters) == nil {
    //      print("Test string was a number")
    //    } else {
    //      isValid = false
    //      print("Test string contained non-digit characters.")
    //    }
    //    "offer_callback.label.incorrect_phone_number" = "Incorrect phone number";
    //    "offer_callback.label.incorrect_email" = "Incorrect email";
    return isValid
  }
  
  var params: [String: AnyObject] {
    let resultParams: [String: AnyObject] = ["type": 2,
                  "region": region!,
                  "region_type": regionType!,
                  "name": name!,
                  "phone": phone!,
                  "form_type":formType!,
                  "email" : email!]
    return resultParams
  }
  
}
