//
//  File.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 16.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

class HomeScrollController: ViewControllerWithMenu {
  // MARK : UI
  
  @IBOutlet weak private var scrollView : UIScrollView!
  
  var childViewController : HomeContentController!
  
  // MARK : View life cycle
  
  override func viewDidLoad() {
    super.viewDidLoad()
    configureRightIndicator()
    scrollView.layoutIfNeeded()
    
    childViewController = self.storyboard!.instantiateViewControllerWithIdentifier(HomeContentControllerId)
      as! HomeContentController
    
    scrollView.addSubview(childViewController.view)
    
    if UIDevice.currentDevice().userInterfaceIdiom == .Pad {
      scrollView.scrollEnabled = false
    }
    
    addChildViewController(childViewController)
  }
  
  
  override func viewWillAppear(animated: Bool) {
    super.viewWillAppear(animated)
    
    childViewController.view.frame.origin.y = 0.0
    childViewController.view.frame.origin.x = 0.0
    childViewController.view.frame.size.width = scrollView.frame.width
    childViewController.view.frame.size.height = 5000
    
    childViewController.view.layoutSubviews()
    scrollView.contentSize = CGSize(width: view.frame.width, height: childViewController.contentHeight)
    
    self.navigationItem.title = LocalizedString("menu.main", description: "Главная")
  }
}
