//
//  PublicWifiOrderCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 20.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class PublicWifiOrderCell: UITableViewCell {
    @IBOutlet weak var firstLabel: UILabel!
    @IBOutlet weak var secondLabel: UILabel!
    @IBOutlet weak var button: NextButton!
    var vc: PublicWifiViewController?
    var wifiBaseOrder: WifiBaseOrder?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
    }
    
    @IBAction func button_touchUpInside(sender: UIButton) {
        let alert = UIAlertController(title: LS(self.wifiBaseOrder!.wifiOrderType! == .offer ? "public_wifi.make_subscribe_for_wifi" : "publie_wifi.sure_to_unsubscribe"), message: nil, preferredStyle: .Alert)
        alert.addAction(UIAlertAction(title: LS("cancel"), style: .Cancel, handler: nil))
        alert.addAction(UIAlertAction(title: "OK", style: .Default, handler: { (alertActiom) in
            
            var params = [
                "access_token": Facade.accessToken!,
                "client_id": Facade.clientId!,
                "server_id": Facade.serverId!,
                "abonent_id": Facade.accountId!,
                "device": self.vc!.device!.device!,
                "link_id" : self.vc!.device!.linkId!
                ] as [String: AnyObject]
            
             print("params = \(params)")
            
            self.parentViewController!.processRequest(true)
            switch self.wifiBaseOrder!.wifiOrderType! {
            case .offer:
                params["tariff_id"] = (self.wifiBaseOrder as! WifiOffer).tariffId!
                Facade.sharedInstance().connectWifi(params, onSuccess: {
                    self.vc!.requestPublicWifi()
                    }, onError: { (error) in
                        AlertViewUtil.showIncorrectAlert(error)
                    }, onFinish: {
                        self.parentViewController!.processRequest(false)
                })
                break
            case .order:
                Facade.sharedInstance().disconnectWifi(params, onSuccess: {
                    self.vc!.requestPublicWifi()
                    }, onError: { (error) in
                        AlertViewUtil.showIncorrectAlert(error)
                    }, onFinish: {
                        self.parentViewController!.processRequest(false)
                })
                break
            }
            
        }))
        self.vc?.presentViewController(alert, animated: true, completion: nil)
    }
    
    func fillCell(wifiBaseOrder: WifiBaseOrder, vc: PublicWifiViewController) {
        self.vc = vc
        self.wifiBaseOrder = wifiBaseOrder
        switch wifiBaseOrder.wifiOrderType! {
        case .offer:
            let wifiOffer = wifiBaseOrder as! WifiOffer
            firstLabel.text = AppLocalization.language() == Language.Kazakh ? wifiOffer.offerKz : wifiOffer.offerRu
            secondLabel.text = "\(wifiOffer.price!)"
            break
        case .order:
            let wifiOfferOrder = wifiBaseOrder as! WifiOfferOrder
            firstLabel.text = AppLocalization.language() == Language.Kazakh ? wifiOfferOrder.tariffKz : wifiOfferOrder.tariffRu
            secondLabel.text = "\(wifiOfferOrder.information!)"
            break
        }
        
        button.setTitle(wifiBaseOrder.wifiOrderType == .offer ? LS("public_wifi.make_subscribe"): LS("public_wifi.unsubscribe"), forState: .Normal)
    }
    
}
