//
//  SubscribeHistoryCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 22.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class SubscribeHistoryCell: UITableViewCell {
  @IBOutlet weak var firstLeftLabel: UILabel!
  @IBOutlet weak var firstRightLabel: UILabel!
  @IBOutlet weak var secondLeftLabel: UILabel!
  @IBOutlet weak var secondRightLabel: UILabel!
  @IBOutlet weak var thirdLeftLabel: UILabel!
  @IBOutlet weak var thirdRightLabel: UILabel!
  @IBOutlet weak var fourthLeftLabel: UILabel!
  @IBOutlet weak var fourthRightLabel: UILabel!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    localizeSubviews()
  }
  
  private func localizeSubviews() {
    firstLeftLabel.localizeWithParent(self, localizedId: "service")
    secondLeftLabel.localizeWithParent(self, localizedId: "packet_in")
    thirdLeftLabel.localizeWithParent(self, localizedId: "packet_out")
    fourthLeftLabel.localizeWithParent(self, localizedId: "debit")
  }
  
  func fillCell(traffic: SubscribePeriod.Traffic) {
    firstRightLabel.text = traffic.serviceInfo
    secondRightLabel.text = "\(traffic.acctinputoctets!)"
    thirdRightLabel.text = "\(traffic.acctoutputoctest!)"
    fourthRightLabel.text = "\(traffic.debit!)"
  }
  
}

extension SubscribeHistoryCell: LocalizedParent {
  var localizedId: String {
    return "subscribe_history"
  }
}
