//
//  Facade+Reports.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

extension Facade {
    func getReportsPeriodList(onSuccess: ([ReportPeriod]) -> Void, onError: (String) -> Void) {
        let params = [
            "access_token": Facade.accessToken!,
            "client_id": Facade.clientId!,
            "server_id": Facade.serverId!,
            "abonent_id": Facade.accountId!
            ] as [String: AnyObject]
        request(Router.GetReportsPeriodList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                var reportPeriods:[ReportPeriod] = []
                for item in json.arrayValue {
                    reportPeriods.append(ReportPeriod(json: item))
                }
                reportPeriods = reportPeriods.reverse()
                onSuccess(reportPeriods)
            }
        })
    }
    
    func getBillList(params: [String: AnyObject], onSuccess: ([Bill]) -> Void, onError: ((error: String) -> Void), onFinish: () -> Void) {
        request(Router.GetBillList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                if let errorMsg = json["error"].string {
                    Router.globalLog.error(errorMsg)
                    onError(error: errorMsg)
                } else {
                    var bills: [Bill] = []
                    if let arr = json.array {
                        for subJson in arr {
                            bills.append(Bill(json: subJson))
                        }
                    }
                    onSuccess(bills)
                }
            }
            onFinish()
        })
    }
    
    func getPaymentList(onSuccess: (payments: [[AnyObject]]) -> Void, onError: ((error: String) -> Void), onFinish: () -> Void) {
        let params = [
            "access_token": Facade.accessToken!,
            "client_id": Facade.clientId!,
            "server_id": Facade.serverId!,
            "abonent_id": Facade.accountId!
            ] as [String: AnyObject]
        request(Router.GetPaymentsList(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                if let errorCode = json["error_code"].string, let errorMsg = json["error"].string {
                    Router.globalLog.error("code: \(errorCode), \(errorMsg)")
                    onError(error: "code: \(errorCode), \(errorMsg)")
                } else {
                    var payments: [[AnyObject]] = []
                    //print("json: \(json)")
                    for subJson in json.arrayValue {
                        let payment = Payment(json: subJson)
                        if payments.count > 0 && (payments.last![0] as! NSDate).isEqualByComponents(payment.systemDate!) {
                            var groupedPayments = payments[payments.count - 1][1] as! [Payment]
                            groupedPayments.append(payment)
                            payments[payments.count - 1][1] = groupedPayments
                        } else {
                            var groupedByDate:[AnyObject] = []
                            groupedByDate.append(payment.systemDate!)
                            groupedByDate.append([payment])
                            payments.append(groupedByDate)
                        }
                    }
                    onSuccess(payments: payments)
                }
            }
            onFinish()
        })
    }
    
    func getBillsDetailed(billId: Int, billType: Int, periodId : Int, onSuccess: (details: [BillDetailItem] ) -> Void, onError: ((error: String) -> Void), onFinish: () -> Void) {
        let params = [
            "access_token": Facade.accessToken!,
            "client_id": Facade.clientId!,
            "server_id": Facade.serverId!,
            "abonent_id": Facade.accountId!,
            "bill_type" : billType,
            "bill_id" : billId,
            "period_id" : periodId
            ] as [String: AnyObject]
        
        print(params)
        
        request(Router.GetBillDetails(params)).responseSwiftyJSON(completionHandler: { (req, resp, json, error) in
            Router.globalLog.debug(req)
            Router.globalLog.debug(json)
            
            if let error = error {
                Router.globalLog.error(error.debugDescription)
                onError(error: error.localizedDescription)
            } else {
                Router.globalLog.debug(resp)
                if let errorCode = json["error_code"].string, let errorMsg = json["error"].string {
                    Router.globalLog.error("code: \(errorCode), \(errorMsg)")
                    onError(error: "code: \(errorCode), \(errorMsg)")
                } else {
                    var details: [BillDetailItem] = []
                    //print("json: \(json)")
                    for subJson in json.arrayValue {
//                        let payment = BillDetail(json: subJson)
//                        if payments.count > 0 && (payments.last![0] as! NSDate).isEqualByComponents(payment.systemDate!) {
//                            var groupedPayments = payments[payments.count - 1][1] as! [Payment]
//                            groupedPayments.append(payment)
//                            payments[payments.count - 1][1] = groupedPayments
//                        } else {
//                            var groupedByDate:[AnyObject] = []
//                            groupedByDate.append(payment.systemDate!)
//                            groupedByDate.append([payment])
//                            payments.append(groupedByDate)
//                        }
                        let detail = BillDetailItem(json: subJson)
                        details.append(detail)
                    }
                    onSuccess(details: details)
                }
            }
        })
    }
    
}
