//
//  Facade.swift
//  Lottery
//
//  Created by Alexandr Zalutskiy on 24.12.14.
//  Copyright (c) 2014 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

let FacadeNotificationErrorKey = "error"
let FacadeNotificationObjectKey = "object"

enum Router: URLRequestConvertible {
    
    static let globalLog = XCGLogger.defaultInstance()
    static let baseURLString = "https://telecom.kz/api"
    
    case SiebelClaimCreate([String: AnyObject])
    case SiebelGetClaimSourceSubList([String: AnyObject])
    case SiebelGetClaimSourceList([String: AnyObject])
    case SiebelGetClaimList([String: AnyObject])
    case SiebelClaimDelete([String: AnyObject])
    case SiebelDamageDelete([String: AnyObject])
    case SiebelDamageCreate([String: AnyObject])
    case SiebelGetDamageSourceList([String: AnyObject])
    case SiebelGetDamageList([String: AnyObject])
    case SiebelAccountGet([String: AnyObject])
    case SetTurboTraffic([String: AnyObject])
    case SetExtTraffic([String: AnyObject])
    case GetLanding([String: AnyObject])
    case GetMenu(Int)
    case GetTariffPlanChangeHistory([String: AnyObject])
    case MythPost([String: AnyObject])
    case CheckParentalControl([String: AnyObject])
    case GetStaticIpAddress([String: AnyObject])
    case GetFramedIpAddressStatus([String: AnyObject])
    case ChangeStaticIp([String: AnyObject])
    case SpecialOffers([String: AnyObject])
    case GetFormType
    case GetCardAndBankTypes([String: AnyObject])
    case GetRegions
    case GetLisetServerId
    case GetGUID([String: AnyObject])
    case CallbackSend([String: AnyObject])
    case GetTargetingList([String: AnyObject])
    case GetProviders([String: AnyObject])
    case ChangeCreditLimit([String: AnyObject])
    case GetActiveSessions([String: AnyObject])
    case SubscribeHistoryForMonth([String: AnyObject])
    case SubscribeHistoryForPeriod([String: AnyObject])
    case DisconnectWifi([String: AnyObject])
    case ConnectWifi([String: AnyObject])
    case PaymentForm(String, [String: AnyObject])
    case GetPublicWifi([String: AnyObject])
    case CreateOrder([String: AnyObject])
    case GetBillDetails([String: AnyObject])
    case GetPaymentsList([String: AnyObject])
    case GetBillList([String: AnyObject])
    case GetReportsPeriodList([String: AnyObject])
    case MailNotification([String: AnyObject])
    case GetMailNotificationList([String: AnyObject])
    case AddSi([String: AnyObject])
    case RemoveSi([String: AnyObject])
    case SavePromisedPayment([String: AnyObject])
    case GetPromisedPayment([String: AnyObject])
    case ChangeInternetAccessPassword([String: AnyObject])
    case ChangeTariff([String: AnyObject])
    case DeviceSettings([String: AnyObject])
    case Forget([String: AnyObject])
    case AltelDevices([String: AnyObject])
    case AltelPeriodsList([String: AnyObject])
    case AltelDetalization([String: AnyObject])
    case Devices([String: AnyObject])
    case Megogo([String : AnyObject])
    case CreateIDTV([String : AnyObject])
    case RemoveIDTV([String : AnyObject])
    case ListIDTVPlans([String : AnyObject])
    case Register([String: AnyObject])
    case Cities
    case City(Int)
    case WiFiPointsForCity(Int)
    case WiFiPoint(Int, Int)
    case BannersForCity(Int)
    case PssPointsForCity(Int)
    case PssPoint(Int, Int)
    case GetAccountServices([String: AnyObject])
    case Position([String : Double])
    case TvListForCity(Int)
    case Tv(Int, Int)
    case InternetListForCity(Int)
    case Internet(Int, Int)
    case RentalListForCity(Int)
    case Rental(Int, Int)
    case PhoneListForCity(Int)
    case Phone(Int, Int)
    case HostingListForCity(Int)
    case Hosting(Int, Int)
    case PackagesListForCity(Int)
    case Packages(Int, Int)
    case CallbackServiceCities(Int)
    case CallbackServiceCityAreas(Int, Int)
    case CallbackServiceCityAreaStreets(Int, Int, Int)
    case CallbackServiceCityAreaStreetHouses(Int, Int, Int, Int)
    case RealCallbackCities
    case SendCallbackRequest(Int, Int, [String: String])
    
    case AskBot([String: AnyObject])
    case ChildBot([String: AnyObject])
    
    var method: Method {
        switch self {
        case .SendCallbackRequest, .Register, .GetGUID, .Megogo, .Devices, .AltelDevices, .Forget, .DeviceSettings, .ChangeTariff, .ChangeInternetAccessPassword, .AltelPeriodsList, .AltelDetalization, .GetPromisedPayment, .SavePromisedPayment, .AddSi, .RemoveSi, .GetMailNotificationList, .MailNotification, .GetReportsPeriodList, .GetBillList, .GetPaymentsList, .GetBillDetails, .CreateOrder, .CreateIDTV, .RemoveIDTV, .ListIDTVPlans, .PaymentForm, .GetPublicWifi, .ConnectWifi, .DisconnectWifi, .SubscribeHistoryForMonth, .SubscribeHistoryForPeriod, .GetActiveSessions, .ChangeCreditLimit, .GetProviders, .GetTargetingList, .CallbackSend, .GetCardAndBankTypes, .SpecialOffers, .ChangeStaticIp, .GetFramedIpAddressStatus, .GetStaticIpAddress, .CheckParentalControl, .MythPost, .GetTariffPlanChangeHistory, .SetExtTraffic, .SetTurboTraffic, .SiebelAccountGet, .SiebelGetDamageList, .SiebelGetDamageSourceList, .SiebelDamageCreate, .SiebelDamageDelete, .SiebelClaimDelete, .SiebelGetClaimList, .SiebelGetClaimSourceList, .SiebelGetClaimSourceSubList, .SiebelClaimCreate, .GetAccountServices, .AskBot, .ChildBot:
            return .POST
        default:
            return .GET
        }
    }
    
    var path: String {
        
        let language = AppLocalization.language()
        var languageCode = language.rawValue
        if languageCode == "kk" {
            languageCode = "kz"
        }
        switch self {
        //      case .GetTariffPlan
        case .SiebelClaimCreate:
            return "siebel/claimCreate.json"
        case .SiebelGetClaimSourceSubList:
            return "siebel/getClaimSourceSubList.json"
        case .SiebelGetClaimSourceList:
            return "siebel/getClaimSourceList.json"
        case .SiebelGetClaimList:
            return "siebel/get_claim_list.json"
        case .SiebelClaimDelete:
            return "siebel/claimDelete.json"
        case .SiebelDamageDelete:
            return "siebel/damageDelete.json"
        case .SiebelDamageCreate:
            return "siebel/damageCreate.json"
        case .SiebelGetDamageSourceList:
            return "siebel/getDamageSourceList.json"
        case .SiebelGetDamageList:
            return "siebel/getDamageList.json"
        case .SiebelAccountGet:
            return "siebel/accountGet.json"
        case .SetTurboTraffic:
            return "devices/add_quota.json"
        case .SetExtTraffic:
            return "devices/set_ext_traffic.json"
        case .GetLanding(let params):
            return "landing/get/\(params["service_id"] as! Int)/\(params["type"] as! String).json"
        case .GetMenu(let id):
            return "menu/get/\(id).json"
        case .GetLisetServerId:
            return "registration/getListServerId.json"
        case .GetAccountServices:
            return "/devices/account_services.json"
        case .Megogo:
            return "megogo/linkget.json"
        case .GetTariffPlanChangeHistory:
            return "devices/get_tariff_plan_chg_history.json"
        case .MythPost:
            return "myth/post.json"
        case .CheckParentalControl:
            return "devices/check_si.json"
        case .GetStaticIpAddress:
            return "devices/get_framed_ip_address_status.json"
        case .GetFramedIpAddressStatus:
            return "devices/get_framed_ip_address_status.json"
        case .ChangeStaticIp:
            return "devices/change_Ipv4_status.json"
        case .SpecialOffers:
            return "targeting/special_offers.json"
        case .GetFormType:
            return "callback/get_form_type.json"
        case .GetCardAndBankTypes:
            return "myth/get_card_bank_card_type.json"
        case .GetRegions:
            return "regions/get_list.json"
        case .GetGUID:
            return "registration/getGuid.json"
        case .CallbackSend:
            return "callback/send.json"
        case .GetTargetingList:
            return "targeting/get_list.json"
        case .GetProviders:
            return "myth/get_providers.json"
        case .ChangeCreditLimit:
            return "devices/change_credit_limit.json"
        case .GetActiveSessions:
            return "devices/get_active_sessions.json"
        case .SubscribeHistoryForMonth:
            return "devices/statistics.json"
        case .SubscribeHistoryForPeriod:
            return "devices/statistics_period.json"
        case .DisconnectWifi:
            return "devices/disconnect_wifi.json"
        case .ConnectWifi:
            return "devices/connect_wifi.json"
        case .PaymentForm(let link, _):
            return link
        case .GetPublicWifi:
            return "devices/get_public_wifi.json"
        case .CreateOrder:
            return "payment/create_order.json"
        case .CreateIDTV:
            return "idtv/create_idtv.json"
        case .RemoveIDTV:
            return "idtv/remove_ott.json"
        case .ListIDTVPlans:
            return "idtv/get_idtv_tariff_plan_list.json"
        case .GetPaymentsList:
            return "payments/get_payment_list.json"
        case .GetBillList:
            return "invoice/get_bill_list.json"
        case .GetReportsPeriodList:
            return "invoice/get_reports_period_list.json"
        case .GetBillDetails:
            return "invoice/bill_detail.json"
        case .MailNotification:
            return "devices/mail_notification.json"
        case .GetMailNotificationList:
            return "devices/get_mail_notification_list.json"
        case .AddSi:
            return "devices/add_si.json"
        case .RemoveSi:
            return "devices/remove_si.json"
        case .SavePromisedPayment:
            return "devices/save_promised_payment.json"
        case .GetPromisedPayment:
            return "devices/get_promised_payment.json"
        case .ChangeInternetAccessPassword:
            return "devices/change_password_internet_access.json"
        case .ChangeTariff:
            return "devices/change_tariff.json"
        case .DeviceSettings:
            return "devices/device_settings.json"
        case .AltelDevices:
            return "devices/get_altel4g_devices.json"
        case .AltelPeriodsList:
            return "devices/get_altel4g_periods_list.json"
        case .AltelDetalization:
            return "devices/altel4g_detalization.json"
        case .Devices:
            return "devices/get_abonent_device_list.json"
        case .Cities:
            return "cities"
        case .City(let id):
            return "cities/\(id)"
        case .WiFiPointsForCity(let id):
            return "cities/\(id)/wifi"
        case .WiFiPoint(let id, let cityId):
            return "cities/\(cityId)/wifi/\(id)"
        case .BannersForCity(let id):
            return "cities/\(id)/banners"
        case .PssPointsForCity(let id):
            return "cities/\(id)/pss"
        case .PssPoint(let id, let cityId):
            return "cities/\(cityId)/pss/\(id)"
        case .TvListForCity(let id):
            return "cities/\(id)/tv"
        case .Tv(let id, let cityId):
            return "cities/\(cityId)/tv/\(id)"
        case .InternetListForCity(let id):
            return "cities/\(id)/internet"
        case .Internet(let id, let cityId):
            return "cities/\(cityId)/internet/\(id)"
        case .RentalListForCity(let id):
            return "cities/\(id)/rental"
        case .Rental(let id, let cityId):
            return "cities/\(cityId)/rental/\(id)"
        case .PhoneListForCity(let id):
            return "cities/\(id)/phone"
        case .Phone(let id, let cityId):
            return "cities/\(cityId)/phone/\(id)"
        case .HostingListForCity(let id):
            return "cities/\(id)/hosting"
        case .Hosting(let id, let cityId):
            return "cities/\(cityId)/hosting/\(id)"
        case .PackagesListForCity(let id):
            return "cities/\(id)/packages"
        case .Packages(let id, let cityId):
            return "cities/\(cityId)/packages/\(id)"
        case .Position:
            return "position"
        case .CallbackServiceCities(let serviceId):
            return "service/\(serviceId)/city"
        case .CallbackServiceCityAreas(let serviceId, let cityId):
            return "service/\(serviceId)/city/\(cityId)"
        case .CallbackServiceCityAreaStreets(let serviceId, let cityId, let streetId):
            return "service/\(serviceId)/city/\(cityId)/street/\(streetId)"
        case .CallbackServiceCityAreaStreetHouses(let serviceId, let cityId, let streetId, let houseId):
            return "service/\(serviceId)/city/\(cityId)/street/\(streetId)/house/\(houseId)"
        case .Register(_):
            return "registration/post.json"
        case .RealCallbackCities:
            return "callback/cities"
        case .SendCallbackRequest(let cityId, let serviceId, _):
            return "callback/cities/\(cityId)/service/\(serviceId)"
        case .Forget:
            return "forget/repair.json"
        case .AskBot:
            return "bot/ask.json"
        case .ChildBot:
            return "bot/child.json"
        }
    }
    
    var URLRequest: NSMutableURLRequest {
        
        let language = AppLocalization.language()
        var languageCode = language.rawValue
        if languageCode == "kk" {
            languageCode = "kz"
        }
        
        let lParameters = [
            "language" : languageCode
        ]
        
        let URL = NSURL(string: Router.baseURLString)!
        var URLWithAPI = URL.URLByAppendingPathComponent(path)
        
        switch self {
        case .CreateOrder:
            URLWithAPI = NSURL(string: "https://telecom.kz/api/payment/create_order.json")
            break
        default:
            break
        }
        
        var mutableURLRequest = NSMutableURLRequest(URL: URLWithAPI!)
        mutableURLRequest.HTTPMethod = method.rawValue
        switch self {
        case .PaymentForm(let link, _):
            mutableURLRequest = NSMutableURLRequest(URL: NSURL(string: link)!)
            mutableURLRequest.HTTPMethod = method.rawValue
            mutableURLRequest.setValue("application/x-www-form-url-encoded; charset=utf-8", forHTTPHeaderField: "Content-Type")
            break
        default:
            break
        }
        mutableURLRequest.addValue("application/json", forHTTPHeaderField: "Accept")
        mutableURLRequest.addValue("Basic ZGV2ZWxvcGVyOnNsb3pueWlwYXJvbA==", forHTTPHeaderField: "Authorization")
        
        switch self {
        case .SiebelClaimCreate(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelGetClaimSourceSubList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelGetClaimSourceList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelGetClaimList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelClaimDelete(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelDamageDelete(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelDamageCreate(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelGetDamageSourceList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetGUID(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelGetDamageList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SiebelAccountGet(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SetTurboTraffic(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SetExtTraffic(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .Position(let parameters):
            return ParameterEncoding.URL.encode(mutableURLRequest, parameters: parameters).0
        case .SendCallbackRequest(_, _, let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            let newURLString = mutableRequest.URL!.absoluteString! + "?language=\(languageCode)"
            mutableRequest.URL = NSURL(string: newURLString)
            return mutableRequest//ParameterEncoding.URL.encode(request, parameters: lParameters).0
        case .Register(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .Devices(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .AltelDevices(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .Forget(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .DeviceSettings(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ChangeTariff(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ChangeInternetAccessPassword(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .AltelPeriodsList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .AltelDetalization(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetPromisedPayment(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SavePromisedPayment(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .AddSi(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .RemoveSi(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetMailNotificationList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .MailNotification(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetReportsPeriodList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetBillList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetBillDetails(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetPaymentsList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .CreateOrder(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .CreateIDTV(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .RemoveIDTV(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ListIDTVPlans(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetPublicWifi(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .PaymentForm(_, let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ConnectWifi(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .DisconnectWifi(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SubscribeHistoryForMonth(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SubscribeHistoryForPeriod(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetActiveSessions(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ChangeCreditLimit(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetProviders(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetTargetingList(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .CallbackSend(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetCardAndBankTypes(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetStaticIpAddress(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .SpecialOffers(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetFramedIpAddressStatus(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ChangeStaticIp(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .CheckParentalControl(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .MythPost(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetTariffPlanChangeHistory(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .Megogo(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .GetAccountServices(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .AskBot(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        case .ChildBot(let params):
            let request = ParameterEncoding.JSON.encode(mutableURLRequest, parameters: params).0
            let mutableRequest = request.mutableCopy() as! NSMutableURLRequest
            return mutableRequest
        default:
            return ParameterEncoding.URL.encode(mutableURLRequest, parameters: lParameters).0
        }
    }
}

class Facade {
    struct FacadeError {
        static let ParsingObject = NSError(domain: "telecom.kz", code: -1000, userInfo: [
            NSLocalizedDescriptionKey: §"error.pasring_object"
            ])
    }
    
    class func sharedInstance() -> Facade {
        struct Shared {
            static let sharedInstance : Facade = Facade()
        }
        return Shared.sharedInstance
    }
    
    internal let notificationCenter = NSNotificationCenter.defaultCenter()
    
    private init() {
        
    }
}
