//
//  AbonentSettingsRequest.swift
//  kt
//
//  Created by Alexander Zalutskiy on 24.08.15.
//  Copyright © 2015 Alexandr Zalutskiy. All rights reserved.
//

import Foundation

class AbonentSettingsRequest {
  var email: String?
  var newPassword: String = ""
  var oldPassword: String = ""
  var retryPassword: String = ""
  var maximumPasswordChangeAttempt: Int?
  var maximumLoginCount: Int?
  var idleTimeout: Int?
  var isAdv: Bool?
  var mobilePhone: Int64?
  var validationMessage = ""
  
  let _abonentSettings: AbonentSettings
  
  init(settings: AbonentSettings) {
    _abonentSettings = settings
    
    email = AbonentInfoManager.sharedInstance.abonentInfo?.email
    if let maxAttempt = settings.maximumPasswordChangeAttempt {
      maximumPasswordChangeAttempt = maxAttempt
    }
    if let maximumCount = settings.maximumLoginCount {
      maximumLoginCount = maximumCount
    }
    if let idle = settings.idleTimeout {
      idleTimeout = idle
    }
    isAdv = settings.isAdv
    if let phone = settings.mobilePhone {
      mobilePhone = phone
    }
  }
  
  init(abonentSettings: AbonentSettings,
       email: String,
       maximumPasswordChangeAttempt: Int,
       maximumLoginCount: Int,
       idleTimeout: Int,
       isAdv: Bool?,
       mobilePhone: Int64,
       oldPassword: String,
       newPassword: String) {
    _abonentSettings = abonentSettings
    
    self.email = email
    self.maximumPasswordChangeAttempt = maximumPasswordChangeAttempt
    self.maximumLoginCount = maximumLoginCount
    self.idleTimeout = idleTimeout
    self.isAdv = isAdv
    self.mobilePhone = mobilePhone
    self.oldPassword = oldPassword
    self.newPassword = newPassword
  }
  
  func validateFields() -> Bool {
    var isValid = true
    if let mobilePhone = mobilePhone where "\(mobilePhone)".characters.count < 10 || "\(mobilePhone)".characters.count > 10  {
      isValid = false
      validationMessage = LS("service_callback.label.incorrect_phone")
      //      "service_callback.label.incorrect_email" = "Некорректный e-mail";
      //      "service_callback.label.incorrect_phone" = "Указан некорректный номер телефона";
    } else if mobilePhone == nil {
      isValid = false
      validationMessage = LS("service_callback.label.incorrect_phone")
    }
    if !isValidEmail(email) {
      validationMessage = validationMessage == "" ? LS("service_callback.label.incorrect_email") : "\(validationMessage); \(LS("service_callback.label.incorrect_email"))"
      isValid = false
    }
    if ( newPassword.characters.count > 0 && !isValidPassword(newPassword) ) {
        validationMessage = validationMessage == "" ? LS("service_callback.label.incorrect_password") : "\(validationMessage); \(LS("service_callback.label.incorrect_password"))"
        isValid = false
    }
    return isValid
  }
  
  var json: JSON {
    var _json = [String: AnyObject]()
    
    if let email = email,
      let oldEmail = AbonentInfoManager.sharedInstance.abonentInfo?.email
      where !email.isEmpty && email != oldEmail {
      _json["email"] = email
    } else if let email = email where
      !email.isEmpty && AbonentInfoManager.sharedInstance.abonentInfo == nil {
      _json["email"] = email
    }
    
    if let maximumPasswordChangeAttempt = maximumPasswordChangeAttempt where maximumPasswordChangeAttempt != 0 && _abonentSettings.maximumPasswordChangeAttempt != maximumPasswordChangeAttempt {
      _json["in_max_pswd_change_attempt"] = maximumPasswordChangeAttempt
    }
    
    if let maximumLoginCount = maximumLoginCount where maximumLoginCount != 0 && _abonentSettings.maximumLoginCount != maximumLoginCount {
      _json["in_max_logon_count"] = maximumLoginCount
    }
    
    if let idleTimeout = idleTimeout where idleTimeout != 0 && _abonentSettings.idleTimeout != idleTimeout {
      _json["out_idle_timeout"] = idleTimeout
    }
    
    if let isAdv = isAdv where isAdv != _abonentSettings.isAdv {
      _json["in_advertisement"] = isAdv ? 1 : 0
    }
    
    if let mobilePhone = mobilePhone where mobilePhone != 0 && _abonentSettings.mobilePhone != mobilePhone {
      _json["mobile_phone"] = String(mobilePhone)
    }
    
    if !oldPassword.isEmpty {
      _json["old_password"] = oldPassword
    }
    
    if !newPassword.isEmpty {
      _json["new_password"] = newPassword
    }
    
    return JSON(_json)
  }
    
}
