//
//  Service.swift
//  kt
//
//  Created by Alexandr Zalutskiy on 19.01.15.
//  Copyright (c) 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

enum Service : Int {
  case Actions, Package, Tv, Internet, Software, Phone, Hosting
  
  var name : String {
    switch self {
    case .Actions:
        return ""
    case .Package:
      return LocalizedString("menu.packets", description: "Пакеты")
    case .Internet:
      return LocalizedString("menu.internet", description: "Интернет")
    case .Tv:
      return LocalizedString("menu.tv", description: "Телевидение")
    case .Software:
      return LocalizedString("menu.rent", description: "Аренда ПО")
    case .Phone:
      return LocalizedString("menu.telephony", description: "Телефония")
    case .Hosting:
      return LocalizedString("menu.hosting", description: "Хостинг")
    }
  }
  
  func colorForRow(row: Int) -> UIColor {

    let countDivided = row / 5
    var mod = row % 5
    if (countDivided != 0 && countDivided % 2 != 0) {
        mod = 3 - (row % 5)
        if (mod < 0) {
            mod = 4
        }
    }
    print(mod)
    //print(countDivided)
    switch self {
    case .Package:
      switch (mod)  {
      case 0:
        return UIColor(red: 0.0, green: 0.63, blue: 0.23, alpha: 1.0)
      case 1:
        return UIColor(red: 0.0, green: 0.59, blue: 0.22, alpha: 1.0)
      case 2:
        return UIColor(red: 0.0, green: 0.5, blue: 0.2, alpha: 1.0)
      case 3:
        return UIColor(red: 0.0, green: 0.44, blue: 0.18, alpha: 1.0)
      case 4:
        return UIColor(red: 0.0, green: 0.38, blue: 0.16, alpha: 1.0)
      default:
        return UIColor.whiteColor()
      }
    case .Internet:
      switch mod {
      case 0:
        return UIColor(red: 0.89, green: 0.0, blue: 0.061, alpha: 1.0)
      case 1:
        return UIColor(red: 0.77, green: 0.08, blue: 0.1, alpha: 1.0)
      case 2:
        return UIColor(red: 0.61, green: 0.04, blue: 0.05, alpha: 1.0)
      case 3:
        return UIColor(red: 0.55, green: 0.02, blue: 0.03, alpha: 1.0)
      case 4:
        return UIColor(red: 0.46, green: 0.02, blue: 0.03, alpha: 1.0)
      default:
        return UIColor.whiteColor()
      }
    case .Tv:
      switch mod {
      case 0:
        return UIColor(red: 1.0, green: 0.76, blue: 0.052, alpha: 1.0)
      case 1:
        return UIColor(red: 0.99, green: 0.72, blue: 0.07, alpha: 1.0)
      case 2:
        return UIColor(red: 0.97, green: 0.62, blue: 0.1, alpha: 1.0)
      case 3:
        return UIColor(red: 0.93, green: 0.56, blue: 0.03, alpha: 1.0)
      case 4:
        return UIColor(red: 0.93, green: 0.5, blue: 0.03, alpha: 1.0)
      default:
        return UIColor.whiteColor()
      }
    case .Software, .Phone:
      switch mod {
      case 0:
        return UIColor(red: 0.04, green: 0.73, blue: 0.93, alpha: 1.0)
      case 1:
        return UIColor(red: 0.02, green: 0.66, blue: 0.88, alpha: 1.0)
      case 2:
        return UIColor(red: 0.02, green: 0.58, blue: 0.82, alpha: 1.0)
      case 3:
        return UIColor(red: 0.02, green: 0.54, blue: 0.77, alpha: 1.0)
      case 4:
        return UIColor(red: 0.01, green: 0.48, blue: 0.69, alpha: 1.0)
      default:
        return UIColor.whiteColor()
      }
    case .Hosting, .Actions:
      switch mod {
      case 0:
        return UIColor(red: 0.0, green: 0.66, blue: 0.57, alpha: 1.0)
      case 1:
        return UIColor(red: 0.0, green: 0.6, blue: 0.52, alpha: 1.0)
      case 2:
        return UIColor(red: 0.01, green: 0.51, blue: 0.45, alpha: 1.0)
      case 3:
        return UIColor(red: 0.0, green: 0.44, blue: 0.38, alpha: 1.0)
      case 4:
        return UIColor(red: 0.0, green: 0.4, blue: 0.34, alpha: 1.0)
      default:
        return UIColor.whiteColor()
      }
    }
  }
  
  var imageName : String {
    switch self {
    case .Package, .Actions:
      return "serviceslist_pack_icon"
    case .Internet:
      return "serviceslist_internet_icon"
    case .Tv:
      return "serviceslist_tv_icon"
    case .Software:
      return "serviceslist_soft_icon"
    case .Phone:
      return "serviceslist_phone_icon"
    case .Hosting:
      return "serviceslist_hosting_icon"
    }
  }
}
