//
//  ValidationUtil.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation



func isValidEmail(testStr:String? = nil) -> Bool {
    print("validate emilId: \(testStr)")
    if let testStr = testStr {
        let emailRegEx = "^(?:(?:(?:(?: )*(?:(?:(?:\\t| )*\\r\\n)?(?:\\t| )+))+(?: )*)|(?: )+)?(?:(?:(?:[-A-Za-z0-9!#$%&’*+/=?^_'{|}~]+(?:\\.[-A-Za-z0-9!#$%&’*+/=?^_'{|}~]+)*)|(?:\"(?:(?:(?:(?: )*(?:(?:[!#-Z^-~]|\\[|\\])|(?:\\\\(?:\\t|[ -~]))))+(?: )*)|(?: )+)\"))(?:@)(?:(?:(?:[A-Za-z0-9](?:[-A-Za-z0-9]{0,61}[A-Za-z0-9])?)(?:\\.[A-Za-z0-9](?:[-A-Za-z0-9]{0,61}[A-Za-z0-9])?)*)|(?:\\[(?:(?:(?:(?:(?:[0-9]|(?:[1-9][0-9])|(?:1[0-9][0-9])|(?:2[0-4][0-9])|(?:25[0-5]))\\.){3}(?:[0-9]|(?:[1-9][0-9])|(?:1[0-9][0-9])|(?:2[0-4][0-9])|(?:25[0-5]))))|(?:(?:(?: )*[!-Z^-~])*(?: )*)|(?:[Vv][0-9A-Fa-f]+\\.[-A-Za-z0-9._~!$&'()*+,;=:]+))\\])))(?:(?:(?:(?: )*(?:(?:(?:\\t| )*\\r\\n)?(?:\\t| )+))+(?: )*)|(?: )+)?$"
        let emailTest = NSPredicate(format:"SELF MATCHES %@", emailRegEx)
        let result = emailTest.evaluateWithObject(testStr)
        return result
    } else {
        return false
    }
}

func isValidIIN(value : String) -> Bool {
    return evaluateRegex("[0-9]{12}", value: value)
}

func isValidPhoneNumber(value:String) -> Bool {
    return evaluateRegex("[0-9]{10}", value:value)
}

func evaluateRegex(regex: String, value : String) -> Bool {
    var result = true
    let predicate = NSPredicate(format:"SELF MATCHES %@", regex)
    result = predicate.evaluateWithObject(value)
    return result
}

func isValidMacAddress(testStr: String) -> Bool {
    //  (([0-9A-Fa-f]{2}[-:]){5}[0-9A-Fa-f]{2})|(([0-9A-Fa-f]{4}\.){2}[0-9A-Fa-f]{4})
    let maxRegEx = "(([0-9A-Fa-f]{2}[-:]){5}[0-9A-Fa-f]{2})|(([0-9A-Fa-f]{4}\\.){2}[0-9A-Fa-f]{4})"
    let macTest = NSPredicate(format:"SELF MATCHES %@", maxRegEx)
    let result = macTest.evaluateWithObject(testStr)
    return result
}

func isValidPassword(password: String) -> Bool {
    let pwdRegEx = "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{8,}$"
    
    //let pwdRegEx = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)[a-zA-Z\\d]{8,}$"
    let pwdTest = NSPredicate(format:"SELF MATCHES %@", pwdRegEx)
    let result = pwdTest.evaluateWithObject(password)
    return result 
}
