//
//  BillDetailedViewController.swift
//  kt
//
//  Created by neox on 14.12.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class BillDetailedViewController : UIViewController, UITableViewDataSource, UITableViewDelegate {
    
    var bill : Bill?
    
    var billId : Int?
    var billType : Int?
    var billPeriod : Int?
    
    var titleString: String?
    @IBOutlet weak var tableView: UITableView!
    var rows: [BillDetailItem] = []
    
    override func viewDidLoad() {
        super.viewDidLoad()
        self.title = titleString
        
        configureTableView()
        requestDetails()
    }
    
    func configureTableView() {
        tableView.rowHeight = UITableViewAutomaticDimension
        tableView.estimatedRowHeight = 300
        tableView.delegate = self
        tableView.dataSource = self
    }
    
    func requestDetails() {
        // billId
        // bill.reportDateId
        // billPeriod
        print(billId!)
        print(bill!.reportDateId!)
        print(billPeriod!)
        //bill!.reportDateId!, billId: billId!,
        Facade.sharedInstance().getBillsDetailed( bill!.reportDateId!, billType: billId!, periodId: billPeriod!, onSuccess: { (details) in
            
            dispatch_async(dispatch_get_main_queue(),{
                self.rows = details
                self.tableView.reloadData()
            })
            
            }, onError: { (errorString) in
            }, onFinish: { () in
            }
        )
//        Facade.sharedInstance().getPaymentList({ (payments) in
//            self.payments = payments
//            self.currentPaymentIndex = payments.count > 0 ? payments.count - 1 : nil
//            }, onError: { (error) in
//                AlertViewUtil.showIncorrectAlert(error)
//            }, onFinish: { () in
//        })
    }
    
}

// UITableViewDataSource
extension BillDetailedViewController {
    
    func numberOfSectionsInTableView(tableView: UITableView) -> Int {
        var numOfSections: Int = 1
        if !rows.isEmpty {
            tableView.separatorStyle = UITableViewCellSeparatorStyle.SingleLine
            numOfSections            = 1
            tableView.backgroundView = nil
        }
        else {
            let noDataLabel: UILabel     = UILabel(frame: CGRect(x: 0, y: 0, width: tableView.bounds.size.width, height: tableView.bounds.size.height))
            noDataLabel.text          = LS("no_data")
            noDataLabel.textColor     = UIColor.darkGrayColor()
            noDataLabel.textAlignment = NSTextAlignment.Center
            tableView.backgroundView  = noDataLabel
            tableView.separatorStyle  = UITableViewCellSeparatorStyle.None
        }
        return numOfSections
    }
    
    func tableView(tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
//        return billPositions.count
        return rows.count
    }
    
    func tableView(tableView: UITableView, cellForRowAtIndexPath indexPath: NSIndexPath) -> UITableViewCell {
        let cell = tableView.dequeueReusableCellWithIdentifier("BillDetailCell", forIndexPath: indexPath) as! BillDetailCell
        cell.labelIndex.text = "\(indexPath.row+1)"
        cell.display(rows[indexPath.row])
        if( indexPath.row % 2 == 0 ) {
            cell.contentView.backgroundColor = UIColor.whiteColor()
        } else {
            cell.contentView.backgroundColor = UIColor.silver()
        }
//        cell.leftLabel.setTextAndSizeToFit(billPositions[indexPath.row].billPosName)
//        cell.rightLabel.setTextAndSizeToFit(billPositions[indexPath.row].debit == nil ? "" : "\(Int(billPositions[indexPath.row].debit!)) тг.")
//        cell.rightLabel.textAlignment = NSTextAlignment.Right
//        //cell.selectionStyle = .None
//        cell.accessoryType = UITableViewCellAccessoryType.DisclosureIndicator
        return cell
    }
    
}
   
