//
//  BillDetail.swift
//  kt
//
//  Created by neox on 14.12.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation

class BillDetailCell : UITableViewCell {
    
    
    @IBOutlet weak var labelIndex: UILabel!
    @IBOutlet weak var labelDevice: UILabel!
    @IBOutlet weak var labelDeviceValue: UILabel!
    @IBOutlet weak var labelDate: UILabel!
    @IBOutlet weak var labelDateValue: UILabel!
    @IBOutlet weak var labelService: UILabel!
    @IBOutlet weak var labelServiceValue: UILabel!
    @IBOutlet weak var labelVolume: UILabel!
    @IBOutlet weak var labeVolumeValue: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var labelUnitValue: UILabel!
    @IBOutlet weak var labelDebit: UILabel!
    @IBOutlet weak var labelDebitValue: UILabel!
    @IBOutlet weak var directionLabel: UILabel!
    @IBOutlet weak var directionLabelValue: UILabel!
    @IBOutlet weak var labelDirectionDetail: UILabel!
    @IBOutlet weak var labelDirectionDetailValue: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        
        labelDevice.text = "Номер устройства"
        labelDate.text = "Дата"
        labelService.text = "Услуга"
        labelVolume.text = "Объем"
        labelUnit.text = "Единица измерения"
        labelDebit.text = "Начислено"
        directionLabel.text = "Направление"
        labelDirectionDetail.text = "Детализация направления"
    }
    
    func display(billItem: BillDetailItem) {
        labelDeviceValue.text = billItem.device
        labelDateValue.text = billItem.serviceDate
        labelServiceValue.text = billItem.name
        labeVolumeValue.text = "\(billItem.serviceCount!)"
        labelUnitValue.text = billItem.scgName
        labelDebitValue.text = "\(billItem.sumDebit!)"
        directionLabelValue.text = billItem.direction
        labelDirectionDetailValue.text = billItem.detail
    }
    
}
