//
//  OnlinePaymentFieldCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 19.05.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class OnlinePaymentFieldCell : UITableViewCell {
    @IBOutlet weak var titleLabel: UILabel!
    @IBOutlet weak var textField: UITextField!
    var textValue = ""
    var vc: OnlinePaymentViewController!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        textField.addTarget(self, action: #selector(OnlinePaymentFieldCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
        textField.applyUITextFieldStyle()
        
    }
    
    func textChanged(textField: UITextField) {
        vc.params[textValue] = textField.text
    }
    
    func fillCell(text: String, vc: OnlinePaymentViewController) {
        textValue = text
        self.vc = vc
        textField.delegate = self.vc
        let abonentInfo = AbonentInfoManager.sharedInstance.abonentInfo
        switch text {
        case "email":
            titleLabel.text = LS("online_payment.email")
            textField.placeholder = "Email"
            textField.text = OnlinePaymentViewController.email != nil ? OnlinePaymentViewController.email! : abonentInfo != nil ? abonentInfo!.email : ""
            textField.keyboardType = UIKeyboardType.EmailAddress
            break
        case "payment_summ":
            titleLabel.text = LS("online_payment.payment_sum")
            textField.placeholder = ""
            textField.text = OnlinePaymentViewController.summ != nil ? OnlinePaymentViewController.summ! : abonentInfo != nil ? "\(abonentInfo!.balance == nil ? 0 : lround(ceil(0 - (abonentInfo!.balance!))))" : ""
            textField.doneAccessory = true
            textField.keyboardType = UIKeyboardType.NumberPad
            break
        default: break
        }
        vc.params[textValue] = textField.text
    }
    
}
