//
//  SettingTextFieldTableViewCell.swift
//  kt
//
//  Created by Alexander Zalutskiy on 19.08.15.
//  Copyright © 2015 Alexandr Zalutskiy. All rights reserved.
//

import UIKit

protocol SettingsCellDelegate {
    func onChangeText(text: String, cell: SettingTextFieldTableViewCell)
}

class SettingTextFieldTableViewCell: UITableViewCell {
    
    @IBOutlet weak var textField: UITextField!
    @IBOutlet private weak var _nameLabel: UILabel!
    var vc: LKSettingsViewController!
    //  var delegate : SettingsCellDelegate!
    var fieldTitle: String!
    var changeListener: ((text: String?) -> Void)?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        //		KeyboardUtil.changeKeyboardType(UIKeyboardType.NumberPad, textField: textField)
        let tap = UITapGestureRecognizer(target: self, action: #selector(SettingTextFieldTableViewCell.labelTap(_:)))
        _nameLabel.addGestureRecognizer(tap)
        textField.applyUITextFieldStyle()
        textField.addTarget(self, action: #selector(SettingTextFieldTableViewCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
    }
    
    func labelTap(sender:UITapGestureRecognizer) {
        print("tap working")
        textField.becomeFirstResponder()
    }
    
    func fillCell(text: String, fieldTitle: String, vc: LKSettingsViewController, maxLength: Int? = nil) {
        //    if !vc.textFields.keys.contains(fieldTitle) {
        //      vc.textFields[fieldTitle] = textField
        //    }
        
        self.fieldTitle = fieldTitle
        self.vc = vc
        self.textField.delegate = vc
        if let maxLength = maxLength {
            self.textField.maxLength = maxLength
        }
        //  abonentSettings: self.abonentSettings!,
        //  email: email,
        //  maximumPasswordChangeAttempt: Int(maximumPasswordChangeAttempt
        //  maximumLoginCount: Int(maximumLoginCount),
        //  idleTimeout: Int(idleTimeout),
        //  isAdv: isAdv,
        //  mobilePhone: Int64(mobilePhone),
        //  oldPassword: oldPassword,
        //  newPassword: newPassword)
    }
    
    func setTitle(text: String) {
        _nameLabel.text = text
    }
    
    func setPlaceholder(text: String) {
        textField.placeholder = text
    }
    
    func setStyle(style: UIKeyboardType) {
        textField.keyboardType = style
    }
    
    func setSecure(secure: Bool) {
        textField.secureTextEntry = secure
    }
    
    func setMyTextField(text: String) {
        textField.text = text
    }
    
    func setAvailable(av: Bool) {
        textField.userInteractionEnabled = av
    }
    
    func getText() -> String {
        return textField.text!
    }
    
    func textChanged(textField: UITextField){
        //    delegate.onChangeText(textField.text!, cell: self)
        if textField.text!.characters.count <= textField.maxLength {
            vc.setParam(fieldTitle, newText: textField)
            self.vc.isChangedSettings()
        }
        
        //changeListener?(text: textField.text)
    }
    
    func getTextField() -> UITextField {
        return textField
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        // Configure the view for the selected state
    }
    
}
