//
//  RBCreationFieldTableCell.swift
//  kt
//
//  Created by Assylkhan Rakhatov on 26.11.16.
//  Copyright © 2016 Alexandr Zalutskiy. All rights reserved.
//

import Foundation
import UIKit

class RBCreationFieldTableCell: UITableViewCell {
  @IBOutlet weak var label: UILabel!
  @IBOutlet weak var textField: UITextField!
  var vc: RBCreationViewController!
  var key: String!
  
  override func awakeFromNib() {
    super.awakeFromNib()
    textField.addTarget(self, action: #selector(RBCreationFieldTableCell.textChanged(_:)), forControlEvents: UIControlEvents.EditingChanged)
  }
  
  func textChanged(textField: UITextField) {
    vc.params[key] = textField.text
  }
  
  func fillCell(key: String, vc: RBCreationViewController) {
    self.vc = vc
    self.key = key
    label.setTextAndSizeToFit((LS("claim_page_menu.label.\(key)")).uppercaseString)
    label.textColor = Color.MyServicesCellGrayColor
    
    switch key {
    case "device_number":
      textField.text = "\(vc.claimListVC.currentSiebelAccountData?.assetNumber ?? "") \(vc.claimListVC.currentSiebelAccountData?.deviceGroupName ?? "")"
      break
    case "claim_type":
      if !vc.damageSourceList.isEmpty {
        textField.text = vc.damageSourceList[0].damageName ?? ""
      }
      break
    default:
      break
    }
    
    textField.delegate = vc
  }
  
}
