//
//  FeedCollectionViewCell.swift
//  kt
//
//  Created by neox on 17.08.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class FeedCollectionViewCell: UICollectionViewCell {
    
    var id : Int? = 0
    
    @IBOutlet weak var image: UIImageView!
    
    @IBOutlet weak var title: UILabel!
    
    @IBOutlet weak var desc: UILabel!
    
    @IBOutlet weak var payButton: UIButtonRoundedBlue!
    
    var navController : UINavigationController?
    
    override func awakeFromNib() {
        super.awakeFromNib()
        let tap = UITapGestureRecognizer(target: self, action: #selector(FeedCollectionViewCell.tapFunction))
        payButton.addGestureRecognizer(tap)
//
//        let tap2 = UITapGestureRecognizer(target: self, action: #selector(FeedCollectionViewCell.tapFunction))
//        image.userInteractionEnabled = true
//        image.addGestureRecognizer(tap2)
    }
    
    func tapFunction(sender:UITapGestureRecognizer) {
        openService()
    }
    
    func openService() {
        let serviceItem = ServiceItem()
        serviceItem.id = self.id
        serviceItem.type = "landing"
        serviceItem.name = self.title.text
        
        let storyboard = UIStoryboard(name: "Main", bundle: nil)
        
        ////this is old version
        //        let destination = storyboard.instantiateViewControllerWithIdentifier("ServiceItemScrollViewController") as! ServiceItemScrollViewController
        //        destination.serviceItemForLoading = serviceItem
        //        navController!.pushViewController(destination, animated: true)
        
        //        let destination = storyboard.instantiateViewControllerWithIdentifier("ServiceCalculatorViewController") as! ServiceCalculatorViewController
        //        destination.serviceItem = serviceItem
        //        navController!.pushViewController(destination, animated: true)
        
        let destination = storyboard.instantiateViewControllerWithIdentifier("ServiceVIPTableViewController") as! ServiceVIPTableViewController
        destination.serviceItem = serviceItem
        navController!.pushViewController(destination, animated: true)
    }
    
    
}
