//
//  UIFastPayTableViewCell.swift
//  kt
//
//  Created by Admin on 18.12.16.
//  Copyright © 2016 SimpleCode. All rights reserved.
//

import Foundation

class FastPayCellData : CellData {
    override internal var cellType: CellType { return CellType.FastPayCell}
    
    internal var onPayClick : (FastPayCellData) -> Void = {_ in }
    internal var name : String = ""
    internal var phoneNumberTitle : String = ""
    internal var phoneNumberValue : String = ""
    internal var creditTitle : String = ""
    internal var accountNumberTitle = ""
    internal var accountNumberValue = ""
    internal var fastPayItem : FastPayItem?
    internal var creditValue : String = "" {
        didSet {
            for (identifier, observer) in observers {
                if (identifier.compare("credit") == .OrderedSame) {
                    observer(currentValue: creditValue)
                }
            }
            
        }
    }
    
    internal var summ : String = ""

    
    init (name : String, phoneNumber : String, credit : String) {
        super.init()
        self.name = name
        self.phoneNumberValue = phoneNumber
        self.creditValue = credit
        self.phoneNumberTitle = LS("fastPayCell_phoneNumber_title").uppercaseString
        self.creditTitle = LS("fastPayCell_credit_title").uppercaseString
        
    }
    
    init (name : String, guid : String, credit : String) {
        super.init()
        self.name = name
        self.accountNumberValue = guid
        self.creditValue = credit
        self.accountNumberTitle = LS("fastPayCell_accountNumber_title").uppercaseString
        self.creditTitle = LS("fastPayCell_credit_title").uppercaseString
        
    }
}

class UIFastPayTableViewCell : UIBaseTableViewCell {
    
    @IBOutlet weak var lblName: UILabel!
    @IBOutlet weak var lblPhoneNumberTitle: UILabel!
    @IBOutlet weak var lblPhoneNumberValue: UILabel!
    @IBOutlet weak var lblCreditTitle: UILabel!
    @IBOutlet weak var lblCreditValue: UILabel!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        removeLeftMargin()
    }
    
    override func fillWithCellData(cellData: CellData) {
        super.fillWithCellData(cellData)
        let myCellData = cellData as! FastPayCellData
        
        lblName.setTextAndSizeToFit(myCellData.name)
        if ( myCellData.fastPayItem!.isPhoneNumber() ) {
            lblPhoneNumberTitle.setTextAndSizeToFit(myCellData.phoneNumberTitle)
            lblPhoneNumberValue.setTextAndSizeToFit("+7\(myCellData.phoneNumberValue)")
        } else {
            lblPhoneNumberTitle.setTextAndSizeToFit(myCellData.accountNumberTitle)
            lblPhoneNumberValue.setTextAndSizeToFit("\(myCellData.accountNumberValue)")
        }
        
        lblCreditTitle.setTextAndSizeToFit(myCellData.creditTitle)
        lblCreditValue.setTextAndSizeToFit(myCellData.creditValue)
        button.setTitle(LS("pay"), forState: .Normal)
        cellData.addObserver("credit") { (currentValue) in
            self.lblCreditValue.setTextAndSizeToFit("\(currentValue!)")
        }
        
        self.cellData = myCellData
        sendRequest()
        
        self.button.titleLabel?.numberOfLines = 0
        self.button.titleLabel?.adjustsFontSizeToFitWidth = true
        self.button.titleLabel?.lineBreakMode = NSLineBreakMode.ByWordWrapping

    }
    
    private func sendRequest() {
        let cellData = self.cellData as! FastPayCellData
        let loadingIndicator = UIActivityIndicatorView()
        loadingIndicator.startAnimating()
        self.addSubview(loadingIndicator)
        
        if cellData.fastPayItem!.isPhoneNumber() {
            Facade.sharedInstance().getBalance(cellData.phoneNumberValue, onSuccess: { (balance) in
                var summ = balance
                if (summ < 0) {
                    summ = summ * -1
                }
                cellData.creditValue = "\(summ) тг."
                cellData.summ = "\(summ)"
//                if balance <= 0 {
//                    self.lblCreditTitle.setTextAndSizeToFit(LS("fastPayCell_credit_title2").uppercaseString)
//                    self.button.enabled = false
//                    self.button.titleLabel?.text = LS("fastPay_positive_balance")
//                }
                loadingIndicator.stopAnimating()
                loadingIndicator.removeFromSuperview()
            }) { (nsError) in
                cellData.creditValue = LS("fastPay_error_during_request")
                loadingIndicator.stopAnimating()
                loadingIndicator.removeFromSuperview()
            }
        } else {
            Facade.sharedInstance().getBalanceByGuid(cellData.accountNumberValue, onSuccess: { (balance) in
                var summ = Double(balance)!
                if (summ < 0) {
                    summ = summ * -1
                }
                cellData.creditValue = "\(summ) тг."
                cellData.summ = "\(summ)"
//                if Double(balance)! <= 0 {
//                    self.lblCreditTitle.setTextAndSizeToFit(LS("fastPayCell_credit_title2").uppercaseString)
//                    self.button.enabled = false
//                    self.button.titleLabel?.text = LS("fastPay_positive_balance")
//                }
                loadingIndicator.stopAnimating()
                loadingIndicator.removeFromSuperview()
            }) { (nsError) in
                cellData.creditValue = LS("fastPay_error_during_request")
                loadingIndicator.stopAnimating()
                loadingIndicator.removeFromSuperview()
            }
        }
    }
    
    
    @IBOutlet weak var button: UIButtonRoundedBlue!
    //MARK: - IBActions
    
    @IBAction func btn_action(sender: AnyObject) {
        let cellData = self.cellData as! FastPayCellData
        cellData.onPayClick(cellData)
    }
    
    
}
