//
//  VIPTVCell.swift
//  kt
//
//  Created by neox on 06.11.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import Foundation
import DLRadioButton

class VIPTVCell : UITableViewCell {
    
    var vc : ServiceVIPTableViewController!
    var price = VIPPrices.VIP_TV_PRICE
    
    @IBOutlet weak var layoutHeader: UIView!
    @IBOutlet weak var labelAudience: UILabel!
    @IBOutlet weak var labelPrice: UILabel!
    @IBOutlet weak var labelUnit: UILabel!
    @IBOutlet weak var labelPlus: UILabel!
    @IBOutlet weak var labelFastInternet: UILabel!
    @IBOutlet weak var labelServiceOption: UILabel!
    @IBOutlet weak var optionButton1: DLRadioButton!
    @IBOutlet weak var optionButton2: DLRadioButton!
    @IBOutlet weak var optionButton3: DLRadioButton!
    
    override func awakeFromNib() {
        super.awakeFromNib()
        
        self.selectionStyle = UITableViewCellSelectionStyle.None
        labelFastInternet.text = LS("service_vip_tv_safe_internet")
        labelServiceOption.text = LS("service_option")
        labelAudience.text = LS("service_vip_tv_audience")
        labelPrice.text = "+\(price)"
        labelUnit.text = LS("tenge_per_month")
        
        optionButton1.setTitle(LS("service_vip_tv_option_1"), forState: .Normal)
        optionButton2.setTitle(LS("service_vip_tv_option_2"), forState: .Normal)
        optionButton3.setTitle(LS("service_vip_tv_option_3"), forState: .Normal)
        
        optionButton1.selected = true
        
//        optionButton1.setButtonWidth()
//        optionButton2.setButtonWidth()
//        optionButton3.setButtonWidth()
        optionButton1.addTarget(self, action: #selector(VIPTVCell.radioButtonClick(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        optionButton2.addTarget(self, action: #selector(VIPTVCell.radioButtonClick(_:)), forControlEvents: UIControlEvents.TouchUpInside)
        optionButton3.addTarget(self, action: #selector(VIPTVCell.radioButtonClick(_:)), forControlEvents: UIControlEvents.TouchUpInside)

    }
    
    func radioButtonClick(sender: DLRadioButton) {
        if ( sender == optionButton1 ) {
            vc.setOptionTVPackage(0)
//            vc.setBoolOptionTVPackageNastroiKino(false)
        } else if ( sender == optionButton2 ) {
            vc.setOptionTVPackage(1)
//            vc.setBoolOptionTVPackageNastroiKino(false)
        } else if ( sender == optionButton3 ) {
            vc.setOptionTVPackage(2)
//            vc.setBoolOptionTVPackageNastroiKino(true)
        }
    }
    
    override func setSelected(selected: Bool, animated: Bool) {
        super.setSelected(selected, animated: animated)
        
        if ( selected ) {
            self.contentView.layer.borderColor = UIColor.ocean().CGColor
            self.contentView.layer.borderWidth = 3
            layoutHeader.backgroundColor = UIColor.ocean()
            labelPlus.textColor = UIColor.ocean()
        } else {
            self.contentView.layer.borderColor = UIColor.clearColor().CGColor
            self.contentView.layer.borderWidth = 0
            layoutHeader.backgroundColor = UIColor.sky()
            labelPlus.textColor = UIColor.sky()
        }
    }
    
}
