//
//  UIButtionRoundedMain.swift
//  kt
//
//  Created by neox on 02.10.17.
//  Copyright © 2017 SimpleCode. All rights reserved.
//

import UIKit

class UIButtionRoundedMain: UIButton {
    
    override func awakeFromNib() {
        super.awakeFromNib()
        setTitleColor(.whiteColor(), forState: UIControlState.Normal)
        setTitleColor(.whiteColor(), forState: UIControlState.Highlighted)
        setTitleColor(.whiteColor(), forState: UIControlState.Selected)
        setTitleColor(.whiteColor(), forState: UIControlState.Disabled)
        setTitleColor(.whiteColor(), forState: UIControlState.Reserved)
        backgroundColor = Color.ButtonBlueDefaultColor
        layer.cornerRadius = 16
    }
    
    override var highlighted: Bool {
        didSet {
            backgroundColor = highlighted ? Color.ButtonBlueHighlightedColor : Color.ButtonBlueDefaultColor
        }
    }
}
